/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.client.level.blockentities.renderer;

import com.github.teamfusion.rottencreatures.client.level.blockentities.model.TreasureChestBlockModel;
import com.github.teamfusion.rottencreatures.client.registries.RCModelLayers;
import com.github.teamfusion.rottencreatures.common.level.blockentities.TreasureChestBlockEntity;
import com.github.teamfusion.rottencreatures.common.level.blocks.TreasureChestBlock;
import com.github.teamfusion.rottencreatures.core.RottenCreatures;
import java.util.Map;
import java.util.WeakHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_827;

@Environment(value=EnvType.CLIENT)
public class TreasureChestBlockRenderer
implements class_827<TreasureChestBlockEntity> {
    private final TreasureChestBlockModel model;
    private static final Map<class_2338, ChestAnimationState> ANIMATION_STATES = new WeakHashMap<class_2338, ChestAnimationState>();

    public TreasureChestBlockRenderer(class_5614.class_5615 context) {
        this.model = new TreasureChestBlockModel(context.method_32140(RCModelLayers.TREASURE_CHEST));
    }

    public void render(TreasureChestBlockEntity blockEntity, float partialTick, class_4587 matrices, class_4597 buffer, int packedLight, int packedOverlay) {
        class_2680 state = blockEntity.method_11010();
        float yRot = 22.5f * (float)((Integer)state.method_11654((class_2769)TreasureChestBlock.ROTATION)).intValue();
        boolean isOpen = (Boolean)state.method_11654((class_2769)TreasureChestBlock.OPEN);
        class_2338 pos = blockEntity.method_11016();
        ChestAnimationState animState = ANIMATION_STATES.computeIfAbsent(pos, p -> new ChestAnimationState(isOpen ? 1.0f : 0.0f));
        long currentTime = System.currentTimeMillis();
        float deltaTime = Math.min(0.1f, (float)(currentTime - animState.lastUpdateTime) / 100.0f);
        animState.lastUpdateTime = currentTime;
        animState.prevOpenness = animState.openness;
        if (isOpen && animState.openness < 1.0f) {
            animState.openness = Math.min(animState.openness + deltaTime * 0.5f, 1.0f);
        } else if (!isOpen && animState.openness > 0.0f) {
            animState.openness = Math.max(animState.openness - deltaTime * 0.5f, 0.0f);
        }
        float animationProgress = class_3532.method_16439((float)partialTick, (float)animState.prevOpenness, (float)animState.openness);
        matrices.method_22903();
        matrices.method_22904(0.5, 0.0, 0.5);
        matrices.method_22905(-1.0f, -1.0f, 1.0f);
        class_4588 vertices = buffer.getBuffer(class_1921.method_28116((class_2960)this.getTextureLocation()));
        this.model.setupAnim(animationProgress, yRot, 0.0f);
        this.model.method_60879(matrices, vertices, packedLight, class_4608.field_21444);
        matrices.method_22909();
    }

    public class_2960 getTextureLocation() {
        return RottenCreatures.resource("textures/block/treasure_chest.png");
    }

    private static class ChestAnimationState {
        public float openness;
        public float prevOpenness;
        public long lastUpdateTime;

        public ChestAnimationState(float initialOpenness) {
            this.openness = initialOpenness;
            this.prevOpenness = initialOpenness;
            this.lastUpdateTime = System.currentTimeMillis();
        }
    }
}

