/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.data.server.tags;

import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import net.minecraft.class_156;
import net.minecraft.class_2378;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_3495;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7475;
import net.minecraft.class_7784;

public abstract class UnverifiableTagsProvider<T>
implements class_2405 {
    protected final class_7784.class_7489 pathProvider;
    private final CompletableFuture<class_7225.class_7874> lookupProvider;
    private final CompletableFuture<Void> contentsDone = new CompletableFuture();
    private final CompletableFuture<TagLookup<T>> parentProvider;
    protected final class_5321<? extends class_2378<T>> registryKey;
    private final Map<class_2960, class_3495> builders = Maps.newLinkedHashMap();

    protected UnverifiableTagsProvider(class_7784 output, class_5321<? extends class_2378<T>> registryKey, CompletableFuture<class_7225.class_7874> lookupProvider) {
        this(output, registryKey, lookupProvider, CompletableFuture.completedFuture(TagLookup.empty()));
    }

    protected UnverifiableTagsProvider(class_7784 output, class_5321<? extends class_2378<T>> registryKey, CompletableFuture<class_7225.class_7874> lookupProvider, CompletableFuture<TagLookup<T>> parentProvider) {
        this.pathProvider = output.method_60918(registryKey);
        this.registryKey = registryKey;
        this.parentProvider = parentProvider;
        this.lookupProvider = lookupProvider;
    }

    public String method_10321() {
        return "Tags for " + String.valueOf(this.registryKey.method_29177());
    }

    protected abstract void addTags(class_7225.class_7874 var1);

    public CompletableFuture<?> method_10319(class_7403 output) {
        record CombinedData<T>(class_7225.class_7874 contents, TagLookup<T> parent) {
        }
        return ((CompletableFuture)((CompletableFuture)this.createContentsProvider().thenApply(provider -> {
            this.contentsDone.complete(null);
            return provider;
        })).thenCombineAsync(this.parentProvider, (x$0, x$1) -> new CombinedData((class_7225.class_7874)x$0, x$1), (Executor)class_156.method_18349())).thenCompose(data -> CompletableFuture.allOf((CompletableFuture[])this.builders.entrySet().stream().map(entry -> {
            class_2960 location = (class_2960)entry.getKey();
            class_3495 builder = (class_3495)entry.getValue();
            List elements = builder.method_26782();
            Path path = this.pathProvider.method_44107(location);
            return class_2405.method_53496((class_7403)output, (class_7225.class_7874)data.contents, (Codec)class_7475.field_39269, (Object)new class_7475(elements, false), (Path)path);
        }).toArray(CompletableFuture[]::new)));
    }

    protected TagAppender<T> tag(class_6862<T> tag) {
        class_3495 tagBuilder = this.getOrCreateRawBuilder(tag);
        return new TagAppender(tagBuilder);
    }

    protected class_3495 getOrCreateRawBuilder(class_6862<T> tag) {
        return this.builders.computeIfAbsent(tag.comp_327(), resourceLocation -> class_3495.method_26778());
    }

    public CompletableFuture<TagLookup<T>> contentsGetter() {
        return this.contentsDone.thenApply(void_ -> tagKey -> Optional.ofNullable(this.builders.get(tagKey.comp_327())));
    }

    protected CompletableFuture<class_7225.class_7874> createContentsProvider() {
        return this.lookupProvider.thenApply(provider -> {
            this.builders.clear();
            this.addTags((class_7225.class_7874)provider);
            return provider;
        });
    }

    @FunctionalInterface
    public static interface TagLookup<T>
    extends Function<class_6862<T>, Optional<class_3495>> {
        public static <T> TagLookup<T> empty() {
            return tagKey -> Optional.empty();
        }
    }

    public static class TagAppender<T> {
        private final class_3495 builder;

        protected TagAppender(class_3495 builder) {
            this.builder = builder;
        }

        public final TagAppender<T> add(class_5321<T> key) {
            this.builder.method_26784(key.method_29177());
            return this;
        }

        @SafeVarargs
        public final TagAppender<T> add(class_5321<T> ... toAdd) {
            for (class_5321<T> resourceKey : toAdd) {
                this.builder.method_26784(resourceKey.method_29177());
            }
            return this;
        }

        public TagAppender<T> addOptional(class_2960 location) {
            this.builder.method_34891(location);
            return this;
        }

        public TagAppender<T> addTag(class_6862<T> tag) {
            this.builder.method_26787(tag.comp_327());
            return this;
        }

        public TagAppender<T> addOptionalTag(class_2960 location) {
            this.builder.method_34892(location);
            return this;
        }
    }
}

