/*
 * Decompiled with CFR 0.152.
 */
package net.tracystacktrace.stackem;

import com.fox2code.foxloader.loader.Mod;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.tracystacktrace.stackem.impl.TagTexturePack;

public class StackEm
extends Mod {
    public static final Logger LOGGER = Logger.getLogger("STACKEM");

    public static int generateRandomNDigitNumber(int digits) {
        int min = (int)Math.pow(10.0, digits - 1);
        int max = (int)(Math.pow(10.0, digits) - 1.0);
        return (int)((double)min + Math.random() * (double)(max - min + 1));
    }

    public static String getRandomStackEmIdentifier() {
        return "stackem" + StackEm.generateRandomNDigitNumber(5);
    }

    public static String[] processIdentifier(String input) {
        int start = input.indexOf(91);
        int end = input.indexOf(93);
        if (start == -1 || end == -1 || !input.contains("stackem")) {
            return new String[0];
        }
        return input.substring(start + 1, end).split(";");
    }

    public static String buildIdentifier(String[] input) {
        if (input == null || input.length < 1) {
            return "stackem[]";
        }
        return "stackem[" + String.join((CharSequence)";", input) + "]";
    }

    public static List<TagTexturePack> buildTexturePackList() {
        File texturepacksDir = new File(Minecraft.getInstance().getMinecraftDir(), "texturepacks");
        if (!texturepacksDir.exists() || !texturepacksDir.isDirectory()) {
            return null;
        }
        ArrayList<TagTexturePack> collector = new ArrayList<TagTexturePack>();
        for (File file : texturepacksDir.listFiles()) {
            Object[] collect$1 = StackEm.fetchDefaultObjects(file);
            if (collect$1 == null || collect$1[0] == null) continue;
            TagTexturePack tagTexturePack = new TagTexturePack(file, file.getName(), (String)collect$1[0], (String)collect$1[1]);
            if (collect$1[2] != null) {
                tagTexturePack.setThumbnail((BufferedImage)collect$1[2]);
            }
            collector.add(tagTexturePack);
        }
        return collector;
    }

    private static Object[] fetchDefaultObjects(File file) {
        Object[] objects = new Object[3];
        try {
            ZipEntry packPng;
            ZipFile zipFile = new ZipFile(file);
            ZipEntry packTxt = zipFile.getEntry("pack.txt");
            if (packTxt != null) {
                try (InputStream inputStream2 = zipFile.getInputStream(packTxt);
                     BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream2));){
                    objects[0] = StackEm.formatDescriptionLine(reader.readLine());
                    objects[1] = StackEm.formatDescriptionLine(reader.readLine());
                }
                catch (IOException inputStream2) {
                    // empty catch block
                }
            }
            if ((packPng = zipFile.getEntry("pack.png")) != null) {
                try (InputStream inputStream = zipFile.getInputStream(packPng);){
                    objects[2] = ImageIO.read(inputStream);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            zipFile.close();
            return objects;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static String formatDescriptionLine(String line) {
        if (line == null || line.length() < 34) {
            return line;
        }
        int maxLength = 34;
        int colorCodeCount = (int)line.chars().limit(maxLength - 1).filter(c -> c == 167).count();
        return line.length() > (maxLength += colorCodeCount * 2) ? line.substring(0, maxLength) : line;
    }
}

