/*
 * Decompiled with CFR 0.152.
 */
package net.tracystacktrace.stackem.gui;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSmallButton;
import net.minecraft.client.renderer.block.ITexturePack;
import net.minecraft.client.renderer.block.TexturePackBase;
import net.minecraft.common.util.i18n.StringTranslate;
import net.tracystacktrace.stackem.StackEm;
import net.tracystacktrace.stackem.gui.GuiTextureStackSlot;
import net.tracystacktrace.stackem.hack.SmartHacks;
import net.tracystacktrace.stackem.impl.TagTexturePack;
import net.tracystacktrace.stackem.impl.TexturePackStacked;
import net.tracystacktrace.stackem.processor.audio.SoundCleanupHelper;
import org.lwjgl.opengl.Display;

public class GuiTextureStack
extends GuiScreen {
    public List<TagTexturePack> sequoiaCache;
    private final String title1;
    private final String title2;
    private final String hint1;
    private final String hint2;
    private GuiTextureStackSlot slotManager;
    private GuiButton buttonMoveUp;
    private GuiButton buttonMoveDown;
    private GuiButton buttonToggle;

    public GuiTextureStack(GuiScreen parentScreen) {
        this.parentScreen = parentScreen;
        StringTranslate translate = StringTranslate.getInstance();
        this.title1 = translate.translateKey("stackem.gui.title");
        this.title2 = translate.translateKey("stackem.gui.folderhint");
        this.hint1 = translate.translateKey("stackem.gui.hint1");
        this.hint2 = translate.translateKey("stackem.gui.hint2");
    }

    public void initGui() {
        this.controlList.clear();
        this.fetchCacheFromOuterworld(StackEm.processIdentifier(this.mc.gameSettings.texturePack));
        StringTranslate translate = StringTranslate.getInstance();
        this.controlList.add(new GuiSmallButton(-1, this.width / 2 - 154, this.height - 48, translate.translateKey("stackem.gui.folder")));
        this.controlList.add(new GuiSmallButton(-2, this.width / 2 + 4, this.height - 48, translate.translateKey("stackem.gui.done")));
        this.slotManager = new GuiTextureStackSlot(this, this.width, this.height);
        this.slotManager.registerScrollButtons(7, 8);
        this.buttonToggle = new GuiButton(-5, 5, 40, 16, 16, "\u00a74\u274c");
        this.controlList.add(this.buttonToggle);
        this.buttonMoveUp = new GuiButton(-3, 5, 58, 16, 16, "\u00a79\u2191");
        this.controlList.add(this.buttonMoveUp);
        this.buttonMoveDown = new GuiButton(-4, 5, 76, 16, 16, "\u00a79\u2193");
        this.controlList.add(this.buttonMoveDown);
        this.buttonToggle.enabled = false;
        this.buttonToggle.visible = false;
        this.buttonMoveUp.enabled = false;
        this.buttonMoveUp.visible = false;
        this.buttonMoveDown.enabled = false;
        this.buttonMoveDown.visible = false;
    }

    protected void actionPerformed(GuiButton button) {
        if (button.enabled) {
            if (button.id == -1) {
                try {
                    Desktop.getDesktop().open(new File(Minecraft.getInstance().getMinecraftDir(), "texturepacks"));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
            if (button.id == -2) {
                this.pushChangesGlobally();
                this.mc.displayGuiScreen(this.parentScreen);
                return;
            }
            if (button.id == -3) {
                this.moveUpElement(this.slotManager.selectedIndex);
                return;
            }
            if (button.id == -4) {
                this.moveDownElement(this.slotManager.selectedIndex);
                return;
            }
            if (button.id == -5) {
                this.slotManager.elementClicked(this.slotManager.selectedIndex, true);
                return;
            }
            this.slotManager.actionPerformed(button);
        }
    }

    public void drawScreen(float mouseX, float mouseY, float deltaTicks) {
        this.drawDefaultBackground();
        this.slotManager.drawElement(this.mc, mouseX, mouseY, deltaTicks);
        this.drawCenteredString(this.fontRenderer, this.title2, this.width / 2 - 77, this.height - 26, 0x808080);
        this.drawString(this.fontRenderer, this.hint1, 2.0f, 2.0f, -1);
        this.drawString(this.fontRenderer, this.hint2, 2.0f, 14.0f, -1);
        super.drawScreen(mouseX, mouseY, deltaTicks);
    }

    public void onGuiClosed() {
        super.onGuiClosed();
        this.sequoiaCache.forEach(p -> p.removeThumbnail(this.mc.renderEngine));
    }

    public void updateMoveButtonsState(int index) {
        if (this.sequoiaCache.get(index).isInStack()) {
            this.buttonToggle.enabled = true;
            this.buttonToggle.visible = true;
            this.buttonToggle.displayString = "\u00a74\u274c";
            this.buttonMoveUp.visible = true;
            this.buttonMoveDown.visible = true;
            this.buttonMoveUp.enabled = index > 0;
            this.buttonMoveDown.enabled = index + 1 < this.countInStackElements();
        } else {
            this.buttonToggle.enabled = true;
            this.buttonToggle.visible = true;
            this.buttonToggle.displayString = "\u00a7a\u2714";
            this.buttonMoveUp.enabled = false;
            this.buttonMoveUp.visible = false;
            this.buttonMoveDown.enabled = false;
            this.buttonMoveDown.visible = false;
        }
    }

    private void fetchCacheFromOuterworld(String[] previousCached) {
        List<TagTexturePack> candidates = StackEm.buildTexturePackList();
        if (candidates == null) {
            this.sequoiaCache = new ArrayList<TagTexturePack>();
            return;
        }
        for (int i = 0; i < previousCached.length; ++i) {
            String s = previousCached[i];
            for (TagTexturePack q : candidates) {
                if (!q.name.equals(s)) continue;
                q.order = i;
            }
        }
        this.sequoiaCache = candidates;
        this.pushSequoiaCacheSort();
    }

    public int getSequoiaCacheSize() {
        return this.sequoiaCache.size();
    }

    public void pushSequoiaCacheSort() {
        this.sequoiaCache.sort((o1, o2) -> {
            if (o1.isInStack() && o2.isInStack()) {
                return Integer.compare(o1.order, o2.order);
            }
            if (o1.isInStack()) {
                return -1;
            }
            if (o2.isInStack()) {
                return 1;
            }
            return o1.name.compareTo(o2.name);
        });
    }

    public void recalculateStack() {
        for (int i = 0; i < this.sequoiaCache.size(); ++i) {
            if (this.sequoiaCache.get(i).isInStack()) {
                this.sequoiaCache.get((int)i).order = i;
            }
            if (this.sequoiaCache.get((int)i).order == -1) break;
        }
    }

    public TagTexturePack getSequoiaCacheElement(int index) {
        return this.sequoiaCache.get(index);
    }

    public boolean isSequoiaCacheElementInStack(int index) {
        return this.sequoiaCache.get(index).isInStack();
    }

    public int countInStackElements() {
        return (int)this.sequoiaCache.stream().filter(TagTexturePack::isInStack).count();
    }

    public void addElementToStack(int index) {
        this.sequoiaCache.get((int)index).order = this.countInStackElements();
        this.pushSequoiaCacheSort();
    }

    public void removeElementFromStack(int index) {
        this.sequoiaCache.get((int)index).order = -1;
        this.pushSequoiaCacheSort();
        this.recalculateStack();
    }

    public void pushChangesGlobally() {
        this.pushSequoiaCacheSort();
        ArrayList<File> files = new ArrayList<File>();
        ArrayList<String> stackemList = new ArrayList<String>();
        for (int i = 0; i < this.countInStackElements(); ++i) {
            files.add(this.sequoiaCache.get((int)i).file);
            stackemList.add(this.sequoiaCache.get((int)i).name);
        }
        this.mc.texturePackList.getSelectedTexturePack().deleteTexturePack(this.mc.renderEngine);
        TexturePackStacked stacked = new TexturePackStacked(StackEm.getRandomStackEmIdentifier(), SmartHacks.getDefaultTexturePack(), files);
        this.mc.texturePackList.setTexturePack((ITexturePack)stacked);
        this.mc.gameSettings.texturePack = StackEm.buildIdentifier(stackemList.toArray(new String[0]));
        this.mc.gameSettings.saveOptions();
        this.mc.renderEngine.refreshTextures();
        this.mc.renderGlobal.loadRenderers();
        this.mc.fontRenderer = new FontRenderer((TexturePackBase)this.mc.texturePackList.getSelectedTexturePack(), this.mc.renderEngine);
        SoundCleanupHelper.cleanupSoundSources(this.mc.sndManager);
        this.mc.sndManager.refreshSounds((ITexturePack)stacked);
        this.mc.sndManager.onSoundOptionsChanged();
        Display.update();
    }

    public void moveUpElement(int index) {
        this.sequoiaCache.get((int)(index - 1)).order = index;
        this.sequoiaCache.get((int)index).order = index - 1;
        this.pushSequoiaCacheSort();
        this.slotManager.elementClicked(index - 1, false);
    }

    public void moveDownElement(int index) {
        this.sequoiaCache.get((int)(index + 1)).order = index;
        this.sequoiaCache.get((int)index).order = index + 1;
        this.pushSequoiaCacheSort();
        this.slotManager.elementClicked(index + 1, false);
    }
}

