/*
 * Decompiled with CFR 0.152.
 */
package net.tracystacktrace.stackem.gui;

import com.indigo3d.util.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.renderer.world.Tessellator;
import net.tracystacktrace.stackem.gui.GuiTextureStack;
import net.tracystacktrace.stackem.impl.TagTexturePack;

public class GuiTextureStackSlot
extends GuiSlot {
    protected GuiTextureStack parentScreen;
    public int selectedIndex = -1;

    public GuiTextureStackSlot(GuiTextureStack parentScreen, int width, int height) {
        super(width, height, 32, height - 55 + 4, 36);
        this.parentScreen = parentScreen;
    }

    protected void elementClicked(int index, boolean doubleClick) {
        this.selectedIndex = index;
        if (doubleClick) {
            if (this.parentScreen.isSequoiaCacheElementInStack(index)) {
                this.parentScreen.removeElementFromStack(index);
            } else {
                this.parentScreen.addElementToStack(index);
            }
        }
        this.parentScreen.updateMoveButtonsState(index);
    }

    protected void drawSlot(Minecraft minecraft, int index, float x, float y, int iconHeight, Tessellator tessellator) {
        TagTexturePack tag = this.parentScreen.getSequoiaCacheElement(index);
        if (tag.hasThumbnail()) {
            tag.bindThumbnail(minecraft.renderEngine);
        } else {
            minecraft.renderEngine.bindTexture(minecraft.renderEngine.getTexture("/textures/gui/unknown_pack.png"));
        }
        if (tag.isInStack()) {
            this.drawGradientRect(x, y, x + 216.0f, y + 32.0f, -1064289630, -1064289630);
        }
        RenderSystem.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        tessellator.startDrawingQuads();
        tessellator.setColorOpaque_I(0xFFFFFF);
        tessellator.addVertexWithUV((double)x, (double)(y + (float)iconHeight), 0.0, 0.0, 1.0);
        tessellator.addVertexWithUV((double)(x + 32.0f), (double)(y + (float)iconHeight), 0.0, 1.0, 1.0);
        tessellator.addVertexWithUV((double)(x + 32.0f), (double)y, 0.0, 1.0, 0.0);
        tessellator.addVertexWithUV((double)x, (double)y, 0.0, 0.0, 0.0);
        tessellator.draw();
        Object showName = tag.name;
        if (tag.isInStack()) {
            showName = "[\u00a7e" + (tag.order + 1) + "\u00a7r] " + (String)showName;
        }
        if (((String)showName).length() > 32) {
            showName = ((String)showName).substring(0, 32).trim() + "...";
        }
        this.parentScreen.drawString(minecraft.fontRenderer, (String)showName, x + 32.0f + 2.0f, y + 1.0f, 0xFFFFFF);
        this.parentScreen.drawString(minecraft.fontRenderer, tag.firstLine, x + 32.0f + 2.0f, y + 12.0f, 0x808080);
        this.parentScreen.drawString(minecraft.fontRenderer, tag.secondLine, x + 32.0f + 2.0f, y + 12.0f + 10.0f, 0x808080);
    }

    public boolean allowTransparency() {
        return true;
    }

    protected int getSize() {
        return this.parentScreen.getSequoiaCacheSize();
    }

    protected boolean isSelected(int index) {
        return this.selectedIndex == index;
    }

    protected int getContentHeight() {
        return this.getSize() * 36;
    }
}

