/*
 * Decompiled with CFR 0.152.
 */
package net.tracystacktrace.stackem.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.client.renderer.block.ITexturePack;
import net.minecraft.client.renderer.block.TexturePackBase;
import net.minecraft.client.renderer.world.RenderEngine;
import net.tracystacktrace.stackem.StackEm;

public class TexturePackStacked
extends TexturePackBase {
    private final File[] archives;
    private final List<ZipFile> stackedTextures;
    private boolean initialized = false;

    public TexturePackStacked(String id, ITexturePack defaultTexturePack, List<File> texturepackArchives) {
        super(id, null, "stackem.tpstacked", defaultTexturePack);
        File[] files = new File[texturepackArchives.size()];
        for (int i = 0; i < files.length; ++i) {
            files[i] = texturepackArchives.get(i);
        }
        this.stackedTextures = new ArrayList<ZipFile>();
        this.archives = files;
    }

    protected void loadDescription() {
        this.firstDescriptionLine = "Stack 'Em Internal";
        this.secondDescriptionLine = "Do not use.";
    }

    public List<ZipFile> getZipFiles() {
        return this.stackedTextures;
    }

    private void initialize() {
        if (!this.initialized) {
            for (int i = 0; i < this.archives.length; ++i) {
                File file = this.archives[i];
                try {
                    this.stackedTextures.add(new ZipFile(file));
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    StackEm.LOGGER.severe("Failed to load texturepack (" + file.getAbsolutePath() + "), reason: " + e.getMessage());
                }
            }
            this.initialized = true;
        }
    }

    public void deleteTexturePack(RenderEngine renderEngine) {
        for (int i = 0; i < this.stackedTextures.size(); ++i) {
            ZipFile zipFile = this.stackedTextures.get(i);
            try {
                if (zipFile == null) continue;
                zipFile.close();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
                StackEm.LOGGER.severe("Failed to close texturepack (" + zipFile.getName() + "), reason: " + e.getMessage());
            }
        }
        this.stackedTextures.clear();
    }

    protected InputStream findResource(String resourcePath) throws IOException {
        if (resourcePath.equals("/pack.png")) {
            throw new FileNotFoundException(resourcePath);
        }
        this.initialize();
        for (int i = 0; i < this.stackedTextures.size(); ++i) {
            ZipFile zipFile = this.stackedTextures.get(i);
            ZipEntry entry = zipFile.getEntry(resourcePath.substring(1));
            if (entry == null) continue;
            return zipFile.getInputStream(entry);
        }
        throw new FileNotFoundException(resourcePath);
    }

    protected URL findResourceURL(String resourcePath) {
        try {
            this.initialize();
        }
        catch (Exception e) {
            return null;
        }
        for (int i = 0; i < this.stackedTextures.size(); ++i) {
            ZipFile zipFile = this.stackedTextures.get(i);
            ZipEntry entry = zipFile.getEntry(resourcePath.substring(1));
            if (entry == null) continue;
            try {
                URL url = new URL("jar:file:" + this.archives[i].getAbsolutePath() + "!/" + entry.getName());
                StackEm.LOGGER.info("Loading audio: (" + url.toString().replace("jar:file:", "") + ")");
                return url;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean checkIfFileExists(String resourcePath) {
        try {
            this.initialize();
            for (int i = 0; i < this.stackedTextures.size(); ++i) {
                ZipFile zipFile = this.stackedTextures.get(i);
                if (zipFile.getEntry(resourcePath.substring(1)) == null) continue;
                return true;
            }
            return false;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public boolean checkIfDirectoryExists(String path) {
        try {
            this.initialize();
            for (int i = 0; i < this.stackedTextures.size(); ++i) {
                ZipFile zipFile = this.stackedTextures.get(i);
                ZipEntry entry = zipFile.getEntry(path.substring(1));
                if (entry == null || !entry.isDirectory()) continue;
                return true;
            }
            return false;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public boolean isCompatible() {
        return true;
    }
}

