/*
 * Decompiled with CFR 0.152.
 */
package net.tracystacktrace.stackem.processor.image;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import net.minecraft.client.renderer.block.ITexturePack;

public class ImageHelper {
    public static boolean isValidTexture(BufferedImage check) {
        return check != null && check.getWidth() == check.getHeight();
    }

    public static BufferedImage scaleImage(BufferedImage original, int targetWidth, int targetHeight) {
        Image resultingImage = original.getScaledInstance(targetWidth, targetHeight, 1);
        BufferedImage outputImage = new BufferedImage(targetWidth, targetHeight, 2);
        Graphics2D g2d = outputImage.createGraphics();
        g2d.drawImage(resultingImage, 0, 0, null);
        g2d.dispose();
        return outputImage;
    }

    public static BufferedImage readImage(ITexturePack texturePack, String name) {
        try {
            InputStream inputStream = texturePack.getResourceAsStream(name);
            BufferedImage image = ImageIO.read(inputStream);
            inputStream.close();
            return image;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static BufferedImage readImage(ZipFile zipFile, String name) {
        try {
            ZipEntry entry = zipFile.getEntry(name.substring(1));
            if (entry != null) {
                InputStream inputStream = zipFile.getInputStream(entry);
                BufferedImage image = ImageIO.read(inputStream);
                inputStream.close();
                return image;
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

