/*
 * Decompiled with CFR 0.152.
 */
package net.tracystacktrace.stackem.gui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.common.util.i18n.StringTranslate;
import net.tracystacktrace.stackem.StackEm;
import net.tracystacktrace.stackem.impl.TexturePackStacked;

public class GuiCharMap
extends GuiScreen {
    private static final String[] FONT_IDENTIFIERS = new String[]{"default.png - ascii", "font_01.png - accented (1)", "font_02.png - nonlatin european (1)", "font_03.png - accented (2)", "font_04.png - nonlatin european (2)", "font_05.png - accented (3)", "font_06.png - nonlatin european (3)", "font_07.png - accented (4)", "font_08.png - nonlatin european (4)", "font_09.png - accented (5)", "font_0A.png - dla"};
    private final GuiButton[] charmapButtons = new GuiButton[256];
    private final char[][] charmapSets = new char[FONT_IDENTIFIERS.length][];
    private final String clickAtCharString;
    private String titlePage = "";
    private byte index = 0;
    private GuiButton buttonLeft;
    private GuiButton buttonRight;
    private int selectedChar = -1;
    private String[] selectedCharDetails;

    public GuiCharMap(GuiScreen parentScreen) {
        this.parentScreen = parentScreen;
        this.fetchFontTxtFile();
        this.clickAtCharString = StringTranslate.getInstance().translateKey("stackem.charmap.detail.empty");
    }

    public void initGui() {
        this.controlList.clear();
        int c_offset_x = this.width - 224 - 35;
        int c_offset_y = this.height / 2 - 112;
        for (int i = 0; i < this.charmapButtons.length; ++i) {
            this.charmapButtons[i] = new GuiButton(i, c_offset_x + i % 16 * 14, c_offset_y + i / 16 * 14, 14, 14, "");
            this.controlList.add(this.charmapButtons[i]);
            this.charmapButtons[i].displayInfo = "";
            this.charmapButtons[i].canDisplayInfo = true;
        }
        this.buttonLeft = new GuiButton(-1, 5, this.height - 50, 40, 20, "<");
        this.controlList.add(this.buttonLeft);
        this.buttonRight = new GuiButton(-2, 45, this.height - 50, 40, 20, ">");
        this.controlList.add(this.buttonRight);
        this.controlList.add(new GuiButton(-3, 5, this.height - 25, 80, 20, StringTranslate.getInstance().translateKey("stackem.charmap.close")));
        this.moveToPage(this.index);
    }

    protected void actionPerformed(GuiButton button) {
        if (button.enabled) {
            if (button.id == -1) {
                if (this.index > 0) {
                    this.index = (byte)(this.index - 1);
                    this.moveToPage(this.index);
                }
                return;
            }
            if (button.id == -2) {
                if (this.index + 1 < FONT_IDENTIFIERS.length) {
                    this.index = (byte)(this.index + 1);
                    this.moveToPage(this.index);
                }
                return;
            }
            if (button.id == -3) {
                this.mc.displayGuiScreen(this.parentScreen);
                return;
            }
            if (button.id >= 0 && button.id < 256) {
                if (this.selectedChar != -1) {
                    this.charmapButtons[this.selectedChar].displayString = Character.toString(this.charmapSets[this.index][this.selectedChar]);
                }
                this.selectedChar = button.id;
                char val = this.charmapSets[this.index][this.selectedChar];
                this.charmapButtons[this.selectedChar].displayString = "\u00a7b" + val;
                StringTranslate translate = StringTranslate.getInstance();
                this.selectedCharDetails = new String[]{translate.translateKey("stackem.charmap.detail.1"), translate.translateKeyFormat("stackem.charmap.detail.2", new Object[]{String.format("\\u%04x", val)}), translate.translateKeyFormat("stackem.charmap.detail.3", this.fontRenderer.getCharWidth(val))};
                GuiScreen.setClipboardString((String)Character.toString(val));
                return;
            }
        }
    }

    public void drawScreen(float mouseX, float mouseY, float deltaTicks) {
        this.drawDefaultBackground();
        this.fontRenderer.drawString("\u00a72Char\u00a7cMap", 5, 11, -1);
        this.fontRenderer.drawString(this.titlePage, 5, 23, -1);
        String[] split1 = FONT_IDENTIFIERS[this.index].split(" - ");
        this.fontRenderer.drawString(split1[0], 5, 47, -1);
        this.fontRenderer.drawString(split1[1], 5, 59, -1);
        if (this.selectedChar != -1) {
            for (int i = 0; i < this.selectedCharDetails.length; ++i) {
                this.fontRenderer.drawString(this.selectedCharDetails[i], 5, 83 + i * 12, -1);
            }
        } else {
            this.fontRenderer.drawString(this.clickAtCharString, 5, 83, -1);
        }
        super.drawScreen(mouseX, mouseY, deltaTicks);
    }

    private void fetchFontTxtFile() {
        TexturePackStacked stacked = StackEm.getContainerInstance();
        try (InputStream inputStream = stacked.getResourceAsStream("/font.txt");
             BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            char[] chars = reader.lines().filter(e -> !e.isEmpty() && !e.startsWith("#")).collect(Collectors.joining()).toCharArray();
            for (int i = 0; i < FONT_IDENTIFIERS.length; ++i) {
                this.charmapSets[i] = new char[256];
                System.arraycopy(chars, 256 * i, this.charmapSets[i], 0, 256);
            }
        }
        catch (IOException e2) {
            StackEm.LOGGER.severe("Couldn't read file: /font.txt");
            StackEm.LOGGER.throwing("GuiCharMap", "fetchFontTxtFile", e2);
        }
    }

    private void moveToPage(int i) {
        this.selectedChar = -1;
        this.selectedCharDetails = null;
        this.buttonLeft.enabled = i > 0;
        this.buttonRight.enabled = i + 1 < this.charmapSets.length;
        this.titlePage = StringTranslate.getInstance().translateKeyFormat("stackem.charmap.page", new Object[]{i + 1, FONT_IDENTIFIERS.length});
        char[] lol = this.charmapSets[i];
        for (int b = 0; b < 256; ++b) {
            this.charmapButtons[b].displayInfo = String.format("\\u%04x", lol[b]);
            this.charmapButtons[b].displayString = Character.toString(lol[b]);
        }
    }
}

