/*
 * Decompiled with CFR 0.152.
 */
package net.tracystacktrace.stackem.impl;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.common.block.icon.Icon;
import net.minecraft.common.block.icon.IconRegister;
import net.minecraft.common.item.ItemStack;
import net.tracystacktrace.stackem.StackEm;
import net.tracystacktrace.stackem.processor.iconswap.ItemIconSwap;
import net.tracystacktrace.stackem.processor.moon.CelestialMeta;
import net.tracystacktrace.stackem.processor.moon.EnumCelestialCycle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeepMeta {
    protected final Int2ObjectMap<List<ItemIconSwap>> mapTexturepacksSwap = new Int2ObjectOpenHashMap();
    public CelestialMeta moonData;
    public CelestialMeta sunData;

    public int getMoonCycle(long ticks) {
        return EnumCelestialCycle.getMoon(this.moonData.cycle, ticks, this.moonData.total);
    }

    public float getMoonScale() {
        return 20.0f * this.moonData.scale;
    }

    public void setMoonData(CelestialMeta metadata) {
        this.moonData = metadata;
    }

    public int getSunCycle(long ticks) {
        return EnumCelestialCycle.getMoon(this.sunData.cycle, ticks, this.sunData.total);
    }

    public float getSunScale() {
        return 30.0f * this.sunData.scale;
    }

    public void setSunData(CelestialMeta metadata) {
        this.sunData = metadata;
    }

    public boolean containsCustomSwapFor(int itemID) {
        return this.mapTexturepacksSwap.containsKey(itemID);
    }

    @Nullable
    public Icon getCustomIcon(@NotNull ItemStack stack) {
        List candidates = (List)this.mapTexturepacksSwap.get(stack.getItemID());
        if (candidates == null || candidates.isEmpty()) {
            return null;
        }
        for (int i = 0; i < candidates.size(); ++i) {
            Icon icon = ((ItemIconSwap)candidates.get(i)).getIcon(stack);
            if (icon == null) continue;
            return icon;
        }
        return null;
    }

    @Nullable
    public String getCustomArmor(@NotNull ItemStack stack) {
        List candidates = (List)this.mapTexturepacksSwap.get(stack.getItemID());
        if (candidates == null || candidates.isEmpty()) {
            return null;
        }
        for (int i = 0; i < candidates.size(); ++i) {
            String icon = ((ItemIconSwap)candidates.get(i)).getArmorTexture(stack);
            if (icon == null) continue;
            return icon;
        }
        return null;
    }

    public void registerAllIcons(@NotNull IconRegister register) {
        for (List listSwaps : this.mapTexturepacksSwap.values()) {
            for (ItemIconSwap single : listSwaps) {
                single.registerIcon(register);
            }
        }
    }

    public void addIconSwapper(int itemID, @NotNull ItemIconSwap set) {
        if (!this.mapTexturepacksSwap.containsKey(itemID)) {
            this.mapTexturepacksSwap.put(itemID, new ArrayList());
        }
        ((List)this.mapTexturepacksSwap.get(itemID)).add(set);
        StackEm.LOGGER.info("Added custom swap set: " + set.toString());
    }

    public void flush() {
        this.moonData = null;
        this.sunData = null;
        this.mapTexturepacksSwap.forEach((i, s) -> s.clear());
        this.mapTexturepacksSwap.clear();
    }
}

