/*
 * Decompiled with CFR 0.152.
 */
package net.tracystacktrace.stackem.processor.iconswap;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IconProcessorException
extends Exception {
    public static final byte INVALID_DATA_OBJECT = 0;
    public static final byte FAILED_JSON_PARSE = 1;
    public static final byte NOT_FOUND_ITEM_ID = 2;
    public static final byte INVALID_ITEM_ID = 3;
    public static final byte INVALID_COMPARABLE_CODE = 4;
    public static final byte ON_NAME_PROCESS_FAILED = 5;
    public static final byte ON_META_PROCESS_FAILED = 6;
    public static final byte INVALID_TEXTURE = 7;
    public static final byte NOT_FOUND_TEXTURE = 8;
    public static final byte INVALID_PRIORITY = 9;
    public static final byte INVALID_DATA_ELEMENT = 10;
    public static final byte INVALID_ARMOR_TEXTURE = 11;
    public static final byte INVALID_ENABLE_COLOR = 12;

    @NotNull
    public static String getErrorCode(byte code, @Nullable String optional) {
        return switch (code) {
            case 0 -> String.format("Invalid \"data\" field in \"stackem.items.json\": %s", optional);
            case 1 -> String.format("Failed to process JSON raw data: %s", optional);
            case 2 -> "Expected an item identifier, but wasn't found!";
            case 3 -> String.format("Invalid \"item\" value: %s", optional);
            case 4 -> "Invalid comparable code!";
            case 5 -> String.format("Failed to process \"onName\" array: %s", optional);
            case 6 -> String.format("Failed to process \"onMeta\" array: %s", optional);
            case 7 -> String.format("Invalid texture path: %s", optional);
            case 8 -> "Expected a texture, but wasn't found!";
            case 9 -> String.format("Invalid \"priority\" value: %s", optional);
            case 10 -> String.format("Invalid \"data\" element: %s", optional);
            case 11 -> String.format("Invalid \"armorTexture\" value: %s", optional);
            case 12 -> String.format("Invalid \"armorEnableColor\" value: %s", optional);
            default -> "Unknown error!";
        };
    }

    public IconProcessorException(byte code, @Nullable String optional, @Nullable Exception e) {
        super(IconProcessorException.getErrorCode(code, optional), e);
    }

    public IconProcessorException(byte code, @Nullable String optional) {
        this(code, optional, null);
    }

    public IconProcessorException(byte code, @Nullable Exception e) {
        this(code, null, e);
    }

    public IconProcessorException(byte code) {
        this(code, null, null);
    }
}

