/*
 * Decompiled with CFR 0.152.
 */
package net.tracystacktrace.stackem.processor.iconswap;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import net.minecraft.common.item.Items;
import net.tracystacktrace.stackem.StackEm;
import net.tracystacktrace.stackem.processor.iconswap.IconProcessorException;
import net.tracystacktrace.stackem.processor.iconswap.ItemIconSwap;
import net.tracystacktrace.stackem.processor.iconswap.swap.ISwapper;
import net.tracystacktrace.stackem.processor.iconswap.swap.TextureByMetadata;
import net.tracystacktrace.stackem.processor.iconswap.swap.TextureByName;
import net.tracystacktrace.stackem.tools.JsonReadHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IconSwapReader {
    public static void process(@NotNull String sourceName, @NotNull String input) throws IconProcessorException {
        block6: {
            try {
                JsonObject root = JsonParser.parseString((String)input).getAsJsonObject();
                if (!root.has("data")) break block6;
                JsonElement dataElement = root.get("data");
                if (dataElement.isJsonArray()) {
                    for (JsonElement element : dataElement.getAsJsonArray()) {
                        if (!element.isJsonObject()) continue;
                        try {
                            IconSwapReader.processItem(element.getAsJsonObject());
                        }
                        catch (IconProcessorException e) {
                            throw new IconProcessorException(10, element.toString(), e);
                        }
                    }
                    break block6;
                }
                throw new IconProcessorException(0, dataElement.toString());
            }
            catch (JsonParseException e) {
                throw new IconProcessorException(1, sourceName, (Exception)((Object)e));
            }
        }
    }

    private static void processItem(@NotNull JsonObject object) throws IconProcessorException {
        JsonElement onMetaElement;
        JsonElement onNameElement;
        int targetItemID = -1;
        if (!object.has("item")) {
            throw new IconProcessorException(2);
        }
        JsonElement itemElement = object.get("item");
        if (itemElement.isJsonPrimitive()) {
            JsonPrimitive itemPrimitive = itemElement.getAsJsonPrimitive();
            if (itemPrimitive.isNumber()) {
                int item_iid = itemPrimitive.getAsInt();
                if (IconSwapReader.isValidItemID(item_iid)) {
                    targetItemID = item_iid;
                }
            } else if (itemPrimitive.isString()) {
                String item_iid = itemPrimitive.getAsString();
                targetItemID = IconSwapReader.getItemIDByName(item_iid);
            }
        }
        if (targetItemID == -1) {
            throw new IconProcessorException(3, String.valueOf(targetItemID));
        }
        TextureByName[] textureByNames = null;
        TextureByMetadata[] textureByMetadata = null;
        if (object.has("onName") && (onNameElement = object.get("onName")).isJsonArray()) {
            try {
                textureByNames = JsonReadHelper.transformArray(onNameElement.getAsJsonArray(), TextureByName::fromJson, TextureByName[]::new);
            }
            catch (IconProcessorException e) {
                throw new IconProcessorException(5, onNameElement.toString(), e);
            }
        }
        if (object.has("onMeta") && (onMetaElement = object.get("onMeta")).isJsonArray()) {
            try {
                textureByMetadata = JsonReadHelper.transformArray(onMetaElement.getAsJsonArray(), TextureByMetadata::fromJson, TextureByMetadata[]::new);
            }
            catch (IconProcessorException e) {
                throw new IconProcessorException(6, onMetaElement.toString(), e);
            }
        }
        if (textureByNames != null) {
            Arrays.sort(textureByNames, Comparator.comparingInt(TextureByName::getPriority));
        }
        if (textureByMetadata != null) {
            Arrays.sort(textureByMetadata, Comparator.comparingInt(TextureByMetadata::getPriority));
        }
        StackEm.getContainerDeepMeta().addIconSwapper(targetItemID, new ItemIconSwap(targetItemID, textureByNames, textureByMetadata));
    }

    @NotNull
    public static String obtainTexture(@NotNull JsonObject object) throws IconProcessorException {
        String texture = null;
        if (object.has("texture")) {
            JsonElement textureElement = object.get("texture");
            if (textureElement.isJsonPrimitive() && textureElement.getAsJsonPrimitive().isString()) {
                texture = textureElement.getAsString();
            } else {
                throw new IconProcessorException(7, textureElement.toString());
            }
        }
        if (texture == null) {
            throw new IconProcessorException(8);
        }
        return texture;
    }

    @Nullable
    public static Integer obtainPriority(@NotNull JsonObject object) throws IconProcessorException {
        if (object.has("priority")) {
            JsonElement element = object.get("priority");
            if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isNumber()) {
                return element.getAsInt();
            }
            throw new IconProcessorException(9, element.toString());
        }
        return null;
    }

    public static void obtainArmorIfPossible(@NotNull ISwapper swapper, @NotNull JsonObject object) throws IconProcessorException {
        JsonElement element;
        if (object.has("armorTexture")) {
            element = object.get("armorTexture");
            if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
                swapper.setArmorTexture(element.getAsString());
            } else {
                throw new IconProcessorException(11, element.toString());
            }
        }
        if (object.has("armorEnableColor")) {
            element = object.get("armorEnableCoor");
            if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isBoolean()) {
                swapper.setEnableColor(element.getAsBoolean());
            } else {
                throw new IconProcessorException(12, element.toString());
            }
        }
    }

    private static boolean isValidItemID(int i) {
        if (i < 0 || i >= Items.ITEMS_LIST.length) {
            return false;
        }
        try {
            return Items.ITEMS_LIST[i] != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static int getItemIDByName(@Nullable String candidate) {
        if (candidate == null || candidate.isEmpty()) {
            return -1;
        }
        return Arrays.stream(Items.ITEMS_LIST).filter(Objects::nonNull).filter(i -> i.getItemName().equals(candidate)).map(i -> i.itemID).findFirst().orElse(-1);
    }
}

