/*
 * Decompiled with CFR 0.152.
 */
package net.tracystacktrace.stackem.processor.iconswap;

import java.util.Arrays;
import java.util.Objects;
import net.minecraft.common.block.icon.Icon;
import net.minecraft.common.block.icon.IconRegister;
import net.minecraft.common.item.ItemStack;
import net.tracystacktrace.stackem.processor.iconswap.swap.ISwapper;
import net.tracystacktrace.stackem.processor.iconswap.swap.TextureByMetadata;
import net.tracystacktrace.stackem.processor.iconswap.swap.TextureByName;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ItemIconSwap(int target, @NotNull TextureByName @Nullable [] textureByNames, @NotNull TextureByMetadata @Nullable [] textureByMetadata) {
    @Nullable
    public Icon getIcon(@NotNull ItemStack stack) {
        int i;
        if (this.anySwapsByMeta()) {
            for (i = 0; i < this.textureByMetadata.length; ++i) {
                TextureByMetadata meta = this.textureByMetadata[i];
                if (!meta.compare(stack.getItemDamage())) continue;
                return meta.textureIcon;
            }
        }
        if (this.anySwapsByName()) {
            for (i = 0; i < this.textureByNames.length; ++i) {
                TextureByName name = this.textureByNames[i];
                if (!name.compareString(stack.getDisplayName())) continue;
                return name.textureIcon;
            }
        }
        return null;
    }

    @Nullable
    public String getArmorTexture(@NotNull ItemStack stack) {
        int i;
        if (this.anySwapsByMeta()) {
            for (i = 0; i < this.textureByMetadata.length; ++i) {
                TextureByMetadata meta = this.textureByMetadata[i];
                if (!meta.hasArmorTexture() || !meta.compare(stack.getItemDamage())) continue;
                return meta.getArmorTexture();
            }
        }
        if (this.anySwapsByName()) {
            for (i = 0; i < this.textureByNames.length; ++i) {
                TextureByName name = this.textureByNames[i];
                if (!name.hasArmorTexture() || !name.compareString(stack.getDisplayName())) continue;
                return name.getArmorTexture();
            }
        }
        return null;
    }

    public void registerIcon(@NotNull IconRegister register) {
        if (this.anySwapsByMeta()) {
            for (ISwapper iSwapper : this.textureByMetadata) {
                ((TextureByMetadata)iSwapper).registerIcon(register);
            }
        }
        if (this.anySwapsByName()) {
            for (ISwapper iSwapper : this.textureByNames) {
                ((TextureByName)iSwapper).registerIcon(register);
            }
        }
    }

    public boolean anySwapsByName() {
        return this.textureByNames != null && this.textureByNames.length > 0;
    }

    public boolean anySwapsByMeta() {
        return this.textureByMetadata != null && this.textureByMetadata.length > 0;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemIconSwap desc = (ItemIconSwap)o;
        return this.target == desc.target && Objects.deepEquals(this.textureByNames, desc.textureByNames) && Objects.deepEquals(this.textureByMetadata, desc.textureByMetadata);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.target, Arrays.hashCode(this.textureByNames), Arrays.hashCode(this.textureByMetadata));
    }

    @Override
    @NotNull
    public String toString() {
        return "SingleItemSwap{target=" + this.target + ", textureByNames=" + Arrays.toString(this.textureByNames) + ", textureByMetadata=" + Arrays.toString(this.textureByMetadata) + "}";
    }
}

