/*
 * Decompiled with CFR 0.152.
 */
package net.tracystacktrace.stackem.processor.iconswap.swap;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.common.block.icon.Icon;
import net.minecraft.common.block.icon.IconRegister;
import net.tracystacktrace.stackem.processor.iconswap.IconProcessorException;
import net.tracystacktrace.stackem.processor.iconswap.IconSwapReader;
import net.tracystacktrace.stackem.processor.iconswap.swap.ISwapper;
import net.tracystacktrace.stackem.tools.JsonReadHelper;
import org.jetbrains.annotations.NotNull;

public class TextureByMetadata
implements ISwapper {
    public static final byte STATIC = 0;
    public static final byte BETWEEN = 1;
    public static final byte BELOW = 2;
    public static final byte AFTER = 3;
    public static final byte FOLLOWING = 4;
    public final byte compareCode;
    public final int[] compareInts;
    public final String texturePath;
    protected int priority = 0;
    protected String armorTexture = null;
    protected boolean armorEnableColor = false;
    public Icon textureIcon;

    public TextureByMetadata(byte compareCode, int @NotNull [] compareInts, @NotNull String texturePath) {
        this.compareCode = compareCode;
        this.compareInts = compareInts;
        this.texturePath = texturePath;
    }

    public boolean compare(int meta) {
        switch (this.compareCode) {
            case 0: {
                return this.compareInts[0] == meta;
            }
            case 1: {
                return this.compareInts[0] <= meta && this.compareInts[1] >= meta;
            }
            case 2: {
                return this.compareInts[0] < meta;
            }
            case 3: {
                return this.compareInts[0] > meta;
            }
            case 4: {
                for (int i = 0; i < this.compareInts.length; ++i) {
                    if (this.compareInts[i] != meta) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public void registerIcon(IconRegister register) {
        this.textureIcon = register.registerIcon(this.texturePath);
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public boolean hasArmorTexture() {
        return this.armorTexture != null;
    }

    @Override
    public String getArmorTexture() {
        return this.armorTexture;
    }

    @Override
    public void setArmorTexture(@NotNull String s) {
        this.armorTexture = s;
    }

    @Override
    public void setEnableColor(boolean b) {
        this.armorEnableColor = b;
    }

    @Override
    public boolean hasColor() {
        return this.armorEnableColor;
    }

    @NotNull
    public static TextureByMetadata fromJson(@NotNull JsonObject object) throws IconProcessorException {
        JsonElement inputElement;
        byte compareCode = -1;
        int[] compareInts = null;
        if (object.has("static") && (inputElement = object.get("static")).isJsonPrimitive() && inputElement.getAsJsonPrimitive().isNumber()) {
            compareCode = 0;
            compareInts = new int[]{inputElement.getAsInt()};
        }
        if (object.has("between") && (inputElement = object.get("between")).isJsonArray()) {
            compareCode = 1;
            compareInts = JsonReadHelper.readIntArray(inputElement.getAsJsonArray());
        }
        if (object.has("below") && (inputElement = object.get("below")).isJsonPrimitive() && inputElement.getAsJsonPrimitive().isNumber()) {
            compareCode = 2;
            compareInts = new int[]{inputElement.getAsInt()};
        }
        if (object.has("after") && (inputElement = object.get("after")).isJsonPrimitive() && inputElement.getAsJsonPrimitive().isNumber()) {
            compareCode = 3;
            compareInts = new int[]{inputElement.getAsInt()};
        }
        if (object.has("following") && (inputElement = object.get("following")).isJsonArray()) {
            compareCode = 4;
            compareInts = JsonReadHelper.readIntArray(inputElement.getAsJsonArray());
        }
        if (compareCode == -1) {
            throw new IconProcessorException(4);
        }
        String texture = IconSwapReader.obtainTexture(object);
        Integer priority = IconSwapReader.obtainPriority(object);
        TextureByMetadata compiled = new TextureByMetadata(compareCode, compareInts, texture);
        if (priority != null) {
            compiled.priority = priority;
        }
        IconSwapReader.obtainArmorIfPossible(compiled, object);
        return compiled;
    }
}

