/*
 * Decompiled with CFR 0.152.
 */
package net.tracystacktrace.stackem.processor.iconswap.swap;

import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.common.block.icon.Icon;
import net.minecraft.common.block.icon.IconRegister;
import net.tracystacktrace.stackem.processor.iconswap.IconProcessorException;
import net.tracystacktrace.stackem.processor.iconswap.IconSwapReader;
import net.tracystacktrace.stackem.processor.iconswap.swap.ISwapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextureByName
implements ISwapper {
    public static final byte EQUALS = 0;
    public static final byte EQUALS_IGNORE_CASE = 1;
    public static final byte CONTAINS = 2;
    public static final byte REGEX = 3;
    public static final byte STARTS_WITH = 4;
    public static final byte ENDS_WITH = 5;
    public final byte compareCode;
    public final String targetString;
    public final String texturePath;
    protected int priority = 0;
    protected String armorTexture = null;
    protected boolean armorEnableColor = false;
    public Icon textureIcon;

    public TextureByName(byte compareCode, @NotNull String targetString, @NotNull String texturePath) {
        this.compareCode = compareCode;
        this.targetString = targetString;
        this.texturePath = texturePath;
    }

    public boolean compareString(@Nullable String itemName) {
        if (itemName == null || itemName.isEmpty()) {
            return false;
        }
        switch (this.compareCode) {
            case 0: {
                return itemName.equals(this.targetString);
            }
            case 1: {
                return itemName.equalsIgnoreCase(this.targetString);
            }
            case 2: {
                return itemName.contains(this.targetString);
            }
            case 4: {
                return itemName.startsWith(this.targetString);
            }
            case 5: {
                return itemName.endsWith(this.targetString);
            }
        }
        return false;
    }

    public void registerIcon(IconRegister register) {
        this.textureIcon = register.registerIcon(this.texturePath);
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public boolean hasArmorTexture() {
        return this.armorTexture != null;
    }

    @Override
    public String getArmorTexture() {
        return this.armorTexture;
    }

    @Override
    public void setArmorTexture(@NotNull String s) {
        this.armorTexture = s;
    }

    @Override
    public void setEnableColor(boolean b) {
        this.armorEnableColor = b;
    }

    @Override
    public boolean hasColor() {
        return this.armorEnableColor;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextureByName textureByName = (TextureByName)o;
        return this.compareCode == textureByName.compareCode && Objects.equals(this.targetString, textureByName.targetString) && Objects.equals(this.texturePath, textureByName.texturePath);
    }

    public int hashCode() {
        return Objects.hash(this.compareCode, this.targetString, this.texturePath);
    }

    public String toString() {
        return "TextureOnName{compareCode=" + this.compareCode + ", targetString='" + this.targetString + "', texturePath='" + this.texturePath + "', textureIcon=" + String.valueOf(this.textureIcon) + "}";
    }

    @NotNull
    public static TextureByName fromJson(@NotNull JsonObject object) throws IconProcessorException {
        byte compareCode = -1;
        String targetString = null;
        if (object.has("equals")) {
            targetString = object.get("equals").getAsString();
            compareCode = 0;
        }
        if (object.has("equalsIgnoreCase")) {
            targetString = object.get("equalsIgnoreCase").getAsString();
            compareCode = 1;
        }
        if (object.has("contains")) {
            targetString = object.get("contains").getAsString();
            compareCode = 2;
        }
        if (object.has("startsWith")) {
            targetString = object.get("startsWith").getAsString();
            compareCode = 4;
        }
        if (object.has("endsWith")) {
            targetString = object.get("endsWith").getAsString();
            compareCode = 5;
        }
        if (compareCode == -1 || targetString == null) {
            throw new IconProcessorException(4);
        }
        String texture = IconSwapReader.obtainTexture(object);
        Integer priority = IconSwapReader.obtainPriority(object);
        TextureByName compiled = new TextureByName(compareCode, targetString, texture);
        if (priority != null) {
            compiled.priority = priority;
        }
        IconSwapReader.obtainArmorIfPossible(compiled, object);
        return compiled;
    }
}

