/*
 * Decompiled with CFR 0.152.
 */
package net.tracystacktrace.stackem.processor.imageglue;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.ITexturePack;
import net.minecraft.client.renderer.block.TexturePackDefault;
import net.tracystacktrace.stackem.StackEm;
import net.tracystacktrace.stackem.impl.TexturePackStacked;
import net.tracystacktrace.stackem.processor.imageglue.segment.SegmentedTexture;
import net.tracystacktrace.stackem.tools.ImageHelper;
import net.tracystacktrace.stackem.tools.hack.SmartHacks;

public final class GlueImages {
    public static BufferedImage processLayering(SegmentedTexture name) {
        TexturePackDefault defaultPack = (TexturePackDefault)SmartHacks.getDefaultTexturePack();
        TexturePackStacked stacked = StackEm.getContainerInstance();
        ImageGlueContainer original = new ImageGlueContainer(ImageHelper.readImage((ITexturePack)defaultPack, name.texture()));
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
        List<ZipFile> zipFiles = stacked.getZipFiles();
        for (int i = zipFiles.size() - 1; i >= 0; --i) {
            ZipFile zipFile = zipFiles.get(i);
            BufferedImage image = ImageHelper.readImage(zipFile, name.texture());
            if (ImageHelper.isValidTexture(image)) {
                images.add(image);
                continue;
            }
            if (image == null) continue;
            image.flush();
        }
        int changesNum = 0;
        for (BufferedImage attack : images) {
            changesNum += original.makeChanges(attack, name);
        }
        StackEm.LOGGER.info("Overwrote " + changesNum + " image segments for: " + name.texture().substring(1));
        for (BufferedImage image : images) {
            image.flush();
        }
        images.clear();
        original.flush();
        return original.canvas;
    }

    public static class ImageGlueContainer {
        public BufferedImage original;
        public BufferedImage canvas;
        private final int original_width;

        public ImageGlueContainer(BufferedImage image) {
            this.original = image;
            this.canvas = new BufferedImage(image.getWidth(), image.getHeight(), 2);
            Graphics2D g2d = this.canvas.createGraphics();
            g2d.setComposite(AlphaComposite.Src);
            g2d.drawImage((Image)image, 0, 0, null);
            g2d.dispose();
            this.original_width = this.original.getWidth();
        }

        private boolean rescaleContainer(int width, int height) {
            if (this.original.getWidth() < width || this.original.getHeight() < height) {
                this.original = ImageHelper.scaleImage(this.original, width, height);
                this.canvas = ImageHelper.scaleImage(this.canvas, width, height);
                return true;
            }
            return false;
        }

        public int makeChanges(BufferedImage attempt, SegmentedTexture holder) {
            if (attempt.getWidth() != this.original.getWidth() && !this.rescaleContainer(attempt.getWidth(), attempt.getHeight())) {
                attempt = ImageHelper.scaleImage(attempt, this.original.getWidth(), this.original.getHeight());
            }
            int width = this.original.getWidth();
            int height = this.original.getHeight();
            int scale = width / this.original_width;
            boolean[] modParts = holder.generateOverwrite();
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int test1;
                    int modPixel;
                    int origPixel = this.original.getRGB(x, y);
                    if (origPixel == (modPixel = attempt.getRGB(x, y)) || (test1 = holder.isInWhatSegment(x, y, scale)) <= -1) continue;
                    modParts[test1] = true;
                }
            }
            int amount = 0;
            for (int i = 0; i < modParts.length; ++i) {
                if (!modParts[i]) continue;
                int x = holder.segments()[i][0] * scale;
                int y = holder.segments()[i][1] * scale;
                int endX = (x + holder.segments()[i][2]) * scale;
                int endY = (y + holder.segments()[i][3]) * scale;
                for (int movY = y; movY < endY; ++movY) {
                    for (int movX = x; movX < endX; ++movX) {
                        this.canvas.setRGB(movX, movY, attempt.getRGB(movX, movY));
                    }
                }
                ++amount;
            }
            return amount;
        }

        public void flush() {
            this.original.flush();
        }

        public void debugSave(String name) {
            try {
                ImageIO.write((RenderedImage)this.canvas, "png", new File(Minecraft.getInstance().getMinecraftDir(), name + ".png"));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

