/*
 * Decompiled with CFR 0.152.
 */
package net.tracystacktrace.stackem.processor.moon;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import net.tracystacktrace.stackem.StackEm;
import net.tracystacktrace.stackem.impl.TexturePackStacked;
import net.tracystacktrace.stackem.processor.IJam;
import net.tracystacktrace.stackem.processor.moon.CelestialMeta;
import net.tracystacktrace.stackem.processor.moon.EnumCelestialCycle;
import org.jetbrains.annotations.NotNull;

public class JamSunTexture
implements IJam {
    @Override
    @NotNull
    public String getPath() {
        return "/stackem.sun.json";
    }

    @Override
    public void process(@NotNull TexturePackStacked stacked, @NotNull String rawJsonContent) {
        try {
            int value4;
            int value42;
            float value3;
            EnumCelestialCycle temp;
            String value2;
            Object value1;
            JsonObject root = JsonParser.parseString((String)rawJsonContent).getAsJsonObject();
            String texture_path = "/textures/environment/sun.png";
            EnumCelestialCycle cycle = EnumCelestialCycle.STATIC;
            float scale = 1.0f;
            int number_x = 1;
            int number_y = 1;
            if (root.has("path") && !((String)(value1 = root.get("path").getAsString())).isEmpty()) {
                if (!((String)value1).startsWith("/")) {
                    value1 = "/" + (String)value1;
                }
                texture_path = value1;
            }
            if (root.has("cycle") && !(value2 = root.get("cycle").getAsString()).isEmpty() && (temp = EnumCelestialCycle.getType(value2)) != null) {
                cycle = temp;
            }
            if (root.has("scale") && (value3 = root.get("scale").getAsFloat()) > 0.0f && value3 <= 128.0f) {
                scale = value3;
            }
            if (root.has("number_x") && (value42 = root.get("number_x").getAsInt()) > 0) {
                number_x = value42;
            }
            if (root.has("number_y") && (value4 = root.get("number_y").getAsInt()) > 0) {
                number_y = value4;
            }
            stacked.getDeepMeta().setSunData(new CelestialMeta(texture_path, cycle, scale, number_x, number_y));
        }
        catch (JsonParseException e) {
            StackEm.LOGGER.severe("Failed to process stackem.sun.json for top texturepack");
            StackEm.LOGGER.throwing("JamSunTexture", "read", e);
        }
    }
}

