/*
 * Decompiled with CFR 0.152.
 */
package net.tracystacktrace.stackem.tools;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.function.Function;
import net.tracystacktrace.stackem.tools.FunctionWithException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsonReadHelper {
    public static int[] readIntArray(@NotNull JsonArray array) {
        int[] result = new int[array.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = array.get(i).getAsInt();
        }
        return result;
    }

    public static <T, E extends Exception> T @Nullable [] readObjectArray(@NotNull JsonObject root, @NotNull String arrayName, @NotNull @NotNull FunctionWithException<@NotNull JsonObject, @NotNull T, E> generator, T @NotNull [] empty) throws E {
        if (!root.has(arrayName)) {
            return null;
        }
        JsonElement element = root.get(arrayName);
        if (!element.isJsonArray()) {
            throw new IllegalStateException(String.format("A json array named %s is either corrupt or not an array!", arrayName));
        }
        HashSet<T> collector = new HashSet<T>();
        for (JsonElement candidate : element.getAsJsonArray()) {
            if (!candidate.isJsonObject()) continue;
            try {
                T value = generator.apply(candidate.getAsJsonObject());
                collector.add(value);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException(String.format("An error occured while processing array %s", arrayName), e);
            }
        }
        return collector.isEmpty() ? null : collector.toArray(empty);
    }

    public static <T, E extends Exception> T @NotNull [] transformArray(@NotNull JsonArray array, @NotNull @NotNull FunctionWithException<@NotNull JsonObject, @NotNull T, E> transformer, @NotNull @NotNull Function<Integer, T @NotNull []> emptyArray) throws E {
        HashSet<T> collector = new HashSet<T>();
        for (JsonElement candidate : array) {
            if (!candidate.isJsonObject()) continue;
            T value = transformer.apply(candidate.getAsJsonObject());
            collector.add(value);
        }
        return collector.toArray(emptyArray.apply(0));
    }

    @Nullable
    public static String extractString(@NotNull JsonObject object, @NotNull String name) {
        JsonElement element;
        if (object.has(name) && (element = object.get(name)).isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
            return element.getAsString();
        }
        return null;
    }
}

