/*
 * Decompiled with CFR 0.152.
 */
package net.tracystacktrace.stackem.tools;

import org.jetbrains.annotations.NotNull;

public final class QuickRNG {
    public static int getBetween(int value, int min, int max) {
        if (max <= min) {
            throw new IllegalArgumentException("The value (max) must be bigger than (min)!");
        }
        int hash = value;
        hash ^= hash << 13;
        hash ^= hash >>> 17;
        hash ^= hash << 5;
        return min + (hash &= Integer.MAX_VALUE) % (max - min);
    }

    public static int getRandomDigits(int digits) {
        int min = (int)Math.pow(10.0, digits - 1);
        int max = (int)(Math.pow(10.0, digits) - 1.0);
        return (int)((double)min + Math.random() * (double)(max - min + 1));
    }

    @NotNull
    public static String getRandomIdentifier() {
        return "stackem" + QuickRNG.getRandomDigits(5);
    }
}

