/*
 * Decompiled with CFR 0.152.
 */
package net.tracystacktrace.stackem.tools;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import net.tracystacktrace.stackem.tools.FunctionWithException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ZipFileHelper {
    @Nullable
    public static ZipEntry getEntryFor(@NotNull ZipFile file, @Nullable String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        return file.getEntry(string);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static String readTextFile(@NotNull ZipFile file, @NotNull ZipEntry entry) throws CustomZipOperationException {
        try (InputStream inputStream = file.getInputStream(entry);){
            String string;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                string = reader.lines().collect(Collectors.joining());
            }
            return string;
        }
        catch (IOException e) {
            throw new CustomZipOperationException("Couldn't read file: " + entry.getName(), e);
        }
    }

    @Nullable
    public static String readTextFile(@NotNull ZipFile file, @NotNull String location) {
        ZipEntry entry;
        if (location.startsWith("/")) {
            location = location.substring(1);
        }
        if ((entry = file.getEntry(location)) == null) {
            return null;
        }
        try {
            return ZipFileHelper.readTextFile(file, entry);
        }
        catch (CustomZipOperationException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static <T> T readTextFile(@NotNull ZipFile file, @NotNull String location, @NotNull FunctionWithException<BufferedReader, T, IOException> generator) {
        ZipEntry entry;
        if (location.startsWith("/")) {
            location = location.substring(1);
        }
        if ((entry = file.getEntry(location)) == null) {
            return null;
        }
        try (InputStream inputStream = file.getInputStream(entry);){
            BufferedReader bufferedReader;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                bufferedReader = generator.apply(reader);
            }
            return (T)bufferedReader;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Nullable
    public static BufferedImage readImage(@NotNull ZipFile file, @NotNull String location) {
        BufferedImage bufferedImage;
        block10: {
            ZipEntry entry;
            if (location.startsWith("/")) {
                location = location.substring(1);
            }
            if ((entry = file.getEntry(location)) == null) {
                return null;
            }
            InputStream inputStream = file.getInputStream(entry);
            try {
                bufferedImage = ImageIO.read(inputStream);
                if (inputStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ignored) {
                    return null;
                }
            }
            inputStream.close();
        }
        return bufferedImage;
    }

    public static class CustomZipOperationException
    extends Exception {
        public CustomZipOperationException(@NotNull String info, @NotNull IOException e) {
            super(info, e);
        }
    }
}

