/*
 * Decompiled with CFR 0.152.
 */
package net.tracystacktrace.stackem;

import com.fox2code.foxevents.EventHandler;
import com.fox2code.foxloader.client.KeyBindingAPI;
import com.fox2code.foxloader.event.client.GuiItemInfoEvent;
import com.fox2code.foxloader.loader.Mod;
import com.google.gson.JsonObject;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.zip.ZipFile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.KeyBinding;
import net.minecraft.common.util.i18n.StringTranslate;
import net.tracystacktrace.stackem.StackEmConfig;
import net.tracystacktrace.stackem.impl.DeepMeta;
import net.tracystacktrace.stackem.impl.TagTexturePack;
import net.tracystacktrace.stackem.impl.TexturePackStacked;
import net.tracystacktrace.stackem.modifications.category.StackemJsonReader;
import net.tracystacktrace.stackem.tools.IOReadHelper;
import net.tracystacktrace.stackem.tools.ZipFileHelper;
import org.lwjgl.input.Keyboard;

public class StackEm
extends Mod {
    public static final StackEmConfig CONFIG = new StackEmConfig();
    public static final Logger LOGGER = Logger.getLogger("STACKEM");
    public static final KeyBinding DEBUG_KEYBIND_FALLBACK = new KeyBinding("stackem.keybind.fallback", 68);
    public static boolean DEBUG_FORCE_FALLBACK = false;

    public static TexturePackStacked getContainerInstance() {
        return (TexturePackStacked)Minecraft.getInstance().texturePackList.getSelectedTexturePack();
    }

    public static DeepMeta getContainerDeepMeta() {
        return StackEm.getContainerInstance().getDeepMeta();
    }

    public static void toggleDefaultTextures() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.thePlayer == null) {
            return;
        }
        DEBUG_FORCE_FALLBACK = !DEBUG_FORCE_FALLBACK;
        mc.renderEngine.refreshTextures();
        mc.thePlayer.addChatMessage(StringTranslate.getInstance().translateKey(DEBUG_FORCE_FALLBACK ? "stackem.debug.on" : "stackem.debug.off"));
    }

    public static String[] unpackSaveString(String input) {
        int start = input.indexOf(91);
        int end = input.indexOf(93);
        if (start == -1 || end == -1 || !input.contains("stackem")) {
            return new String[0];
        }
        return input.substring(start + 1, end).split(";");
    }

    public static String packSaveString(String[] input) {
        if (input == null || input.length < 1) {
            return "stackem[]";
        }
        return "stackem[" + String.join((CharSequence)";", input) + "]";
    }

    public static boolean isValidWebsite(String website) {
        return website != null && (website.startsWith("https://") || website.startsWith("http://"));
    }

    public static List<TagTexturePack> fetchTexturepackList() {
        File texturepacksDir = new File(Minecraft.getInstance().getMinecraftDir(), "texturepacks");
        if (!texturepacksDir.exists() || !texturepacksDir.isDirectory()) {
            return null;
        }
        File[] filesArray = texturepacksDir.listFiles();
        if (filesArray == null || filesArray.length == 0) {
            return null;
        }
        ArrayList<TagTexturePack> collector = new ArrayList<TagTexturePack>();
        for (File file : filesArray) {
            TagTexturePack tagTexturePack;
            if (file.isDirectory() || !file.getName().toLowerCase().endsWith(".zip") || (tagTexturePack = StackEm.fetchTexturepackFromZip(file)) == null) continue;
            collector.add(tagTexturePack);
        }
        return collector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static TagTexturePack fetchTexturepackFromZip(File file) {
        try (ZipFile zipFile = new ZipFile(file);){
            String stackemJsonContent;
            String[] packTxtContent = ZipFileHelper.readTextFile(zipFile, "pack.txt", reader -> {
                String line1 = reader.readLine();
                String line2 = reader.readLine();
                return new String[]{line1, line2};
            });
            if (packTxtContent == null) {
                TagTexturePack tagTexturePack = null;
                return tagTexturePack;
            }
            if (packTxtContent[0] == null || packTxtContent[0].isEmpty()) {
                packTxtContent[0] = "";
            }
            if (packTxtContent[1] == null || packTxtContent[1].isEmpty()) {
                packTxtContent[1] = "";
            }
            TagTexturePack tagTexturePack = new TagTexturePack(file, file.getName(), packTxtContent[0], packTxtContent[1]);
            BufferedImage packPngImage = ZipFileHelper.readImage(zipFile, "pack.png");
            if (packPngImage != null) {
                tagTexturePack.setThumbnail(packPngImage);
            }
            if ((stackemJsonContent = ZipFileHelper.readTextFile(zipFile, "stackem.json")) != null) {
                try {
                    JsonObject object_1 = IOReadHelper.processJson(stackemJsonContent);
                    StackemJsonReader.pushJson(object_1, tagTexturePack);
                }
                catch (IOReadHelper.CustomIOException e) {
                    LOGGER.severe("Failed to process texturepack descriptor file (stackem.json)!");
                    LOGGER.throwing("StackEm", "fetchTexturepackFromZip", e);
                    e.printStackTrace();
                }
            }
            zipFile.close();
            TagTexturePack tagTexturePack2 = tagTexturePack;
            return tagTexturePack2;
        }
        catch (IOException e) {
            return null;
        }
    }

    public void onPreInit() {
        this.setConfigObject(CONFIG);
        KeyBindingAPI.registerKeyBinding((KeyBinding)DEBUG_KEYBIND_FALLBACK);
    }

    @EventHandler
    public void eventProvideMetadataInfo(GuiItemInfoEvent event) {
        if (Keyboard.isKeyDown((int)29)) {
            event.addDescriptionLine("\u00a78[meta/max]: " + event.getItemStack().getItemDamage() + "/" + event.getItemStack().getMaxDamage());
        }
    }
}

