/*
 * Decompiled with CFR 0.152.
 */
package net.tracystacktrace.stackem.gui;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.block.ITexturePack;
import net.minecraft.client.renderer.block.TexturePackBase;
import net.minecraft.common.util.i18n.StringTranslate;
import net.tracystacktrace.stackem.StackEm;
import net.tracystacktrace.stackem.gui.GuiCharMap;
import net.tracystacktrace.stackem.gui.GuiTextureStackSlot;
import net.tracystacktrace.stackem.hacks.SmartHacks;
import net.tracystacktrace.stackem.hacks.SoundCleanupHelper;
import net.tracystacktrace.stackem.impl.TagTexturePack;
import net.tracystacktrace.stackem.impl.TexturePackStacked;
import net.tracystacktrace.stackem.tools.QuickRNG;
import org.lwjgl.opengl.Display;

public class GuiTextureStack
extends GuiScreen {
    public List<TagTexturePack> sequoiaCache;
    private final String hint1;
    private final String hint2;
    private final String actions;
    private GuiTextureStackSlot slotManager;
    private GuiButton buttonMoveUp;
    private GuiButton buttonMoveDown;
    private GuiButton buttonToggle;
    private GuiButton buttonWebsite;
    private boolean clickedAtLeastOnce;

    public GuiTextureStack(GuiScreen parentScreen) {
        this.parentScreen = parentScreen;
        StringTranslate translate = StringTranslate.getInstance();
        this.hint1 = translate.translateKey("stackem.gui.hint1");
        this.hint2 = translate.translateKey("stackem.gui.hint2");
        this.actions = translate.translateKey("stackem.gui.actions");
    }

    public void initGui() {
        this.clickedAtLeastOnce = false;
        this.controlList.clear();
        this.fetchCacheFromOuterworld(StackEm.unpackSaveString(this.mc.gameSettings.texturePack));
        StringTranslate translate = StringTranslate.getInstance();
        GuiButton openFolder = new GuiButton(-1, this.width - 120, this.height - 25, 20, 20, "\u00a79\u2604", translate.translateKey("stackem.gui.folder"));
        openFolder.canDisplayInfo = true;
        this.controlList.add(openFolder);
        this.controlList.add(new GuiButton(-2, this.width - 95, this.height - 25, 90, 20, translate.translateKey("stackem.gui.done")));
        GuiButton charMap = new GuiButton(-3, this.width - 145, this.height - 25, 20, 20, "\u00a73\u2664", translate.translateKey("stackem.gui.charmap"));
        charMap.canDisplayInfo = true;
        this.controlList.add(charMap);
        this.slotManager = new GuiTextureStackSlot(this, this.width, this.height);
        this.slotManager.registerScrollButtons(7, 8);
        this.buttonToggle = new GuiButton(-105, 5, 20, 16, 16, "\u00a74\u274c", translate.translateKey("stackem.button.remove"));
        this.controlList.add(this.buttonToggle);
        this.buttonWebsite = new GuiButton(-106, 5, 38, 16, 16, "\u00a7b\u2139", translate.translateKey("stackem.button.website"));
        this.controlList.add(this.buttonWebsite);
        this.buttonMoveDown = new GuiButton(-104, 23, 38, 16, 16, "\u00a79\u2193", translate.translateKey("stackem.button.movedown"));
        this.controlList.add(this.buttonMoveDown);
        this.buttonMoveUp = new GuiButton(-103, 23, 20, 16, 16, "\u00a79\u2191", translate.translateKey("stackem.button.moveup"));
        this.controlList.add(this.buttonMoveUp);
        this.buttonToggle.enabled = false;
        this.buttonToggle.visible = false;
        this.buttonToggle.canDisplayInfo = true;
        this.buttonMoveUp.enabled = false;
        this.buttonMoveUp.visible = false;
        this.buttonMoveUp.canDisplayInfo = true;
        this.buttonMoveDown.enabled = false;
        this.buttonMoveDown.visible = false;
        this.buttonMoveDown.canDisplayInfo = true;
        this.buttonWebsite.enabled = false;
        this.buttonWebsite.visible = false;
        this.buttonWebsite.canDisplayInfo = true;
    }

    protected void actionPerformed(GuiButton button) {
        if (button.enabled) {
            if (button.id == -1) {
                try {
                    Desktop.getDesktop().open(new File(Minecraft.getInstance().getMinecraftDir(), "texturepacks"));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
            if (button.id == -2) {
                this.pushChangesGlobally();
                this.mc.displayGuiScreen(this.parentScreen);
                return;
            }
            if (button.id == -3) {
                this.mc.displayGuiScreen((GuiScreen)new GuiCharMap(this));
                return;
            }
            if (button.id == -103) {
                this.moveUpElement(this.slotManager.selectedIndex);
                return;
            }
            if (button.id == -104) {
                this.moveDownElement(this.slotManager.selectedIndex);
                return;
            }
            if (button.id == -105) {
                this.slotManager.elementClicked(this.slotManager.selectedIndex, true);
                return;
            }
            if (button.id == -106) {
                String website = this.sequoiaCache.get(this.slotManager.selectedIndex).getWebsite();
                if (StackEm.isValidWebsite(website)) {
                    try {
                        Desktop.getDesktop().browse(new URI(website));
                    }
                    catch (IOException | URISyntaxException exception) {
                        // empty catch block
                    }
                }
                return;
            }
            this.slotManager.actionPerformed(button);
        }
    }

    public void drawScreen(float mouseX, float mouseY, float deltaTicks) {
        this.drawDefaultBackground();
        this.slotManager.drawElement(this.mc, mouseX, mouseY, deltaTicks);
        if (this.clickedAtLeastOnce) {
            this.drawString(this.fontRenderer, this.actions, 5.0f, 7.0f, -1);
        }
        this.drawString(this.fontRenderer, this.hint1, 3.0f, this.height - 14, -1);
        this.drawString(this.fontRenderer, this.hint2, 3.0f, this.height - 26, -1);
        super.drawScreen(mouseX, mouseY, deltaTicks);
    }

    public void onGuiClosed() {
        super.onGuiClosed();
        this.sequoiaCache.forEach(p -> p.removeThumbnail(this.mc.renderEngine));
    }

    public void updateScreen() {
        super.updateScreen();
        this.slotManager.tickAnimation();
    }

    public void updateMoveButtonsState(int index) {
        this.clickedAtLeastOnce = true;
        if (this.sequoiaCache.get(index).isInStack()) {
            this.buttonToggle.enabled = true;
            this.buttonToggle.visible = true;
            this.buttonToggle.displayString = "\u00a74\u274c";
            this.buttonToggle.displayInfo = StringTranslate.getInstance().translateKey("stackem.button.remove");
            this.buttonMoveUp.visible = true;
            this.buttonMoveDown.visible = true;
            this.buttonWebsite.visible = true;
            this.buttonMoveUp.enabled = index > 0;
            this.buttonMoveDown.enabled = index + 1 < this.countInStackElements();
        } else {
            this.buttonToggle.enabled = true;
            this.buttonToggle.visible = true;
            this.buttonToggle.displayString = "\u00a7a\u2714";
            this.buttonToggle.displayInfo = StringTranslate.getInstance().translateKey("stackem.button.add");
            this.buttonMoveUp.enabled = false;
            this.buttonMoveUp.visible = false;
            this.buttonMoveDown.enabled = false;
            this.buttonMoveDown.visible = false;
            this.buttonWebsite.visible = true;
            this.buttonWebsite.displayInfo = StringTranslate.getInstance().translateKey("stackem.button.website.0");
        }
        TagTexturePack pack = this.sequoiaCache.get(index);
        this.buttonWebsite.enabled = StackEm.isValidWebsite(pack.getWebsite());
        this.buttonWebsite.displayInfo = pack.hasAuthor() && pack.hasWebsite() ? StringTranslate.getInstance().translateKeyFormat("stackem.button.website.2", new Object[]{pack.getAuthor()}) : (pack.hasAuthor() ? StringTranslate.getInstance().translateKeyFormat("stackem.button.website.1", new Object[]{pack.getAuthor()}) : StringTranslate.getInstance().translateKey("stackem.button.website.0"));
    }

    private void fetchCacheFromOuterworld(String[] previousCached) {
        List<TagTexturePack> candidates = StackEm.fetchTexturepackList();
        if (candidates == null) {
            this.sequoiaCache = new ArrayList<TagTexturePack>();
            return;
        }
        for (int i = 0; i < previousCached.length; ++i) {
            String s = previousCached[i];
            for (TagTexturePack q : candidates) {
                if (!q.name.equals(s)) continue;
                q.order = i;
            }
        }
        this.sequoiaCache = candidates;
        this.sequoiaCache.forEach(TagTexturePack::buildCategory);
        this.pushSequoiaCacheSort();
    }

    public int getSequoiaCacheSize() {
        return this.sequoiaCache.size();
    }

    public void pushSequoiaCacheSort() {
        this.sequoiaCache.sort((o1, o2) -> {
            if (o1.isInStack() && o2.isInStack()) {
                return Integer.compare(o1.order, o2.order);
            }
            if (o1.isInStack()) {
                return -1;
            }
            if (o2.isInStack()) {
                return 1;
            }
            return o1.name.compareTo(o2.name);
        });
    }

    public void recalculateStack() {
        for (int i = 0; i < this.sequoiaCache.size(); ++i) {
            if (this.sequoiaCache.get(i).isInStack()) {
                this.sequoiaCache.get((int)i).order = i;
            }
            if (this.sequoiaCache.get((int)i).order == -1) break;
        }
    }

    public TagTexturePack getSequoiaCacheElement(int index) {
        return this.sequoiaCache.get(index);
    }

    public boolean isSequoiaCacheElementInStack(int index) {
        return this.sequoiaCache.get(index).isInStack();
    }

    public int countInStackElements() {
        return (int)this.sequoiaCache.stream().filter(TagTexturePack::isInStack).count();
    }

    public void addElementToStack(int index) {
        this.sequoiaCache.get((int)index).order = this.countInStackElements();
        this.pushSequoiaCacheSort();
    }

    public void removeElementFromStack(int index) {
        this.sequoiaCache.get((int)index).order = -1;
        this.pushSequoiaCacheSort();
        this.recalculateStack();
    }

    public void pushChangesGlobally() {
        this.pushSequoiaCacheSort();
        ArrayList<File> files = new ArrayList<File>();
        ArrayList<String> stackemList = new ArrayList<String>();
        for (int i = 0; i < this.countInStackElements(); ++i) {
            files.add(this.sequoiaCache.get((int)i).file);
            stackemList.add(this.sequoiaCache.get((int)i).name);
        }
        StackEm.DEBUG_FORCE_FALLBACK = false;
        StackEm.getContainerInstance().deleteTexturePack(this.mc.renderEngine);
        TexturePackStacked stacked = new TexturePackStacked(QuickRNG.getRandomIdentifier(), SmartHacks.getDefaultTexturePack(), files);
        this.mc.texturePackList.setTexturePack((ITexturePack)stacked);
        this.mc.gameSettings.texturePack = StackEm.packSaveString(stackemList.toArray(new String[0]));
        this.mc.gameSettings.saveOptions();
        this.mc.renderEngine.refreshTextures();
        this.mc.renderGlobal.loadRenderers();
        this.mc.fontRenderer = new FontRenderer((TexturePackBase)StackEm.getContainerInstance(), this.mc.renderEngine);
        SoundCleanupHelper.cleanupSoundSources(this.mc.sndManager);
        this.mc.sndManager.refreshSounds((ITexturePack)stacked);
        this.mc.sndManager.onSoundOptionsChanged();
        Display.update();
    }

    public void moveUpElement(int index) {
        this.sequoiaCache.get((int)(index - 1)).order = index;
        this.sequoiaCache.get((int)index).order = index - 1;
        this.pushSequoiaCacheSort();
        this.slotManager.elementClicked(index - 1, false);
    }

    public void moveDownElement(int index) {
        this.sequoiaCache.get((int)(index + 1)).order = index;
        this.sequoiaCache.get((int)index).order = index + 1;
        this.pushSequoiaCacheSort();
        this.slotManager.elementClicked(index + 1, false);
    }
}

