/*
 * Decompiled with CFR 0.152.
 */
package net.tracystacktrace.stackem.gui;

import com.indigo3d.util.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.renderer.world.Tessellator;
import net.tracystacktrace.stackem.gui.GuiTextureStack;
import net.tracystacktrace.stackem.impl.TagTexturePack;
import net.tracystacktrace.stackem.tools.StringFeatures;

public class GuiTextureStackSlot
extends GuiSlot {
    protected GuiTextureStack parentScreen;
    public int selectedIndex = -1;
    private byte animationClock;
    private final boolean[] descriptionIndex;
    private final byte[] animationIndex;
    private final byte[] maxAnimationIndex;

    public GuiTextureStackSlot(GuiTextureStack parentScreen, int width, int height) {
        super(width, height, 0, height - 30, 36, 320);
        this.parentScreen = parentScreen;
        this.animationIndex = new byte[this.getSize()];
        this.maxAnimationIndex = new byte[this.getSize()];
        this.descriptionIndex = new boolean[this.getSize()];
        for (int i = 0; i < this.animationIndex.length; ++i) {
            TagTexturePack tag = parentScreen.getSequoiaCacheElement(i);
            this.maxAnimationIndex[i] = tag.hasCategories() ? (byte)tag.getBakedCSS().length : (byte)0;
        }
    }

    public void tickAnimation() {
        if (this.animationClock == 40) {
            int i;
            for (i = 0; i < this.animationIndex.length; ++i) {
                if (this.maxAnimationIndex[i] == 0) continue;
                int n = i;
                this.animationIndex[n] = (byte)(this.animationIndex[n] + 1);
                if (this.animationIndex[i] != this.maxAnimationIndex[i]) continue;
                this.animationIndex[i] = 0;
            }
            for (i = 0; i < this.descriptionIndex.length; ++i) {
                this.descriptionIndex[i] = !this.descriptionIndex[i];
            }
            this.animationClock = 0;
        } else {
            this.animationClock = (byte)(this.animationClock + 1);
        }
    }

    protected void elementClicked(int index, boolean doubleClick) {
        this.selectedIndex = index;
        if (doubleClick) {
            if (this.parentScreen.isSequoiaCacheElementInStack(index)) {
                this.parentScreen.removeElementFromStack(index);
            } else {
                this.parentScreen.addElementToStack(index);
            }
        }
        this.parentScreen.updateMoveButtonsState(index);
        TagTexturePack tag = this.parentScreen.getSequoiaCacheElement(index);
        this.animationIndex[index] = 0;
        this.animationClock = 0;
        if (tag.hasCategories()) {
            this.maxAnimationIndex[index] = (byte)tag.getBakedCSS().length;
        }
    }

    protected void drawSlot(Minecraft minecraft, int index, float x, float y, int iconHeight, Tessellator tessellator) {
        boolean isSelectedOne;
        TagTexturePack tag = this.parentScreen.getSequoiaCacheElement(index);
        boolean bl = isSelectedOne = this.selectedIndex == index;
        if (tag.hasThumbnail()) {
            tag.bindThumbnail(minecraft.renderEngine);
        } else {
            minecraft.renderEngine.bindTexture(minecraft.renderEngine.getTexture("/textures/gui/unknown_pack.png"));
        }
        if (tag.isInStack()) {
            this.drawGradientRect(x, y, x + 316.0f, y + 32.0f, -1064289630, -1064289630);
        }
        RenderSystem.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        tessellator.startDrawingQuads();
        tessellator.setColorOpaque_I(0xFFFFFF);
        tessellator.addVertexWithUV((double)x, (double)(y + (float)iconHeight), 0.0, 0.0, 1.0);
        tessellator.addVertexWithUV((double)(x + (float)iconHeight), (double)(y + (float)iconHeight), 0.0, 1.0, 1.0);
        tessellator.addVertexWithUV((double)(x + (float)iconHeight), (double)y, 0.0, 1.0, 0.0);
        tessellator.addVertexWithUV((double)x, (double)y, 0.0, 0.0, 0.0);
        tessellator.draw();
        Object showName = tag.name;
        if (tag.isInStack()) {
            showName = "[\u00a7e" + (tag.order + 1) + "\u00a7r] " + (String)showName;
        }
        if (!isSelectedOne) {
            showName = StringFeatures.limitString((String)showName, 44, true);
        }
        this.parentScreen.drawString(minecraft.fontRenderer, (String)showName, x + (float)iconHeight + 2.0f, y + 1.0f, 0xFFFFFF);
        if (tag.hasCategories()) {
            if (tag.secondLine == null || tag.secondLine.isEmpty()) {
                this.parentScreen.drawString(minecraft.fontRenderer, tag.firstLine, x + (float)iconHeight + 2.0f, y + 12.0f, 0x808080);
            } else {
                this.parentScreen.drawString(minecraft.fontRenderer, this.descriptionIndex[index] ? tag.secondLine : tag.firstLine, x + (float)iconHeight + 2.0f, y + 12.0f, 0x808080);
            }
            this.parentScreen.drawString(minecraft.fontRenderer, tag.getBakedCSS()[this.animationIndex[index]], x + (float)iconHeight + 2.0f, y + 22.0f, -1);
        } else {
            this.parentScreen.drawString(minecraft.fontRenderer, tag.firstLine, x + (float)iconHeight + 2.0f, y + 12.0f, 0x808080);
            this.parentScreen.drawString(minecraft.fontRenderer, tag.secondLine, x + (float)iconHeight + 2.0f, y + 12.0f + 11.0f, 0x808080);
        }
    }

    public boolean allowTransparency() {
        return true;
    }

    protected int getSize() {
        return this.parentScreen.getSequoiaCacheSize();
    }

    protected boolean isSelected(int index) {
        return this.selectedIndex == index;
    }

    protected int getContentHeight() {
        return this.getSize() * 36;
    }
}

