/*
 * Decompiled with CFR 0.152.
 */
package net.tracystacktrace.stackem.mixins.processor;

import com.indigo3d.util.RenderSystem;
import net.minecraft.client.renderer.world.RenderGlobal;
import net.minecraft.client.renderer.world.Tessellator;
import net.minecraft.common.world.World;
import net.tracystacktrace.stackem.StackEm;
import net.tracystacktrace.stackem.impl.DeepMeta;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RenderGlobal.class})
public class MixinRenderGlobal {
    @Shadow
    private World worldObj;
    @Unique
    boolean stackem$moonTrigger1;
    @Unique
    boolean stackem$sunTrigger1;

    @Redirect(method={"renderSky"}, at=@At(value="INVOKE", target="Lcom/indigo3d/util/RenderSystem;bindTexture2D(Ljava/lang/String;)V"))
    private void stackem$putCustomMoonTexture(String textureLocation) {
        if (StackEm.getContainerInstance().hasCustomMoon() && textureLocation.equals("/textures/environment/moon.png")) {
            textureLocation = StackEm.getContainerInstance().getDeepMeta().moonData.path;
        }
        if (StackEm.getContainerInstance().hasCustomSun() && textureLocation.equals("/textures/environment/sun.png")) {
            textureLocation = StackEm.getContainerInstance().getDeepMeta().sunData.path;
        }
        RenderSystem.bindTexture2D((String)textureLocation);
    }

    @Redirect(method={"renderSky"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/world/Tessellator;addVertexWithUV(DDDDD)V"))
    private void stackem$redirectRenderNonStaticMoon(Tessellator instance, double x, double y, double z, double u, double v) {
        if (StackEm.getContainerInstance().hasCustomSun() && y == 100.0) {
            if (this.stackem$sunTrigger1) {
                return;
            }
            this.stackem$sunTrigger1 = true;
            DeepMeta deepMeta = StackEm.getContainerInstance().getDeepMeta();
            int sunPhase = deepMeta.getSunCycle(this.worldObj.getWorldTime());
            int amX = deepMeta.sunData.number_x;
            int amY = deepMeta.sunData.number_y;
            float sunSize = deepMeta.getSunScale();
            int phaseX = sunPhase % amX;
            int phaseY = sunPhase / amX % amY;
            float u1 = (float)phaseX / (float)amX;
            float v1 = (float)phaseY / (float)amY;
            float u2 = (float)(phaseX + 1) / (float)amX;
            float v2 = (float)(phaseY + 1) / (float)amY;
            instance.addVertexWithUV((double)(-sunSize), 100.0, (double)(-sunSize), (double)u1, (double)v1);
            instance.addVertexWithUV((double)sunSize, 100.0, (double)(-sunSize), (double)u2, (double)v1);
            instance.addVertexWithUV((double)sunSize, 100.0, (double)sunSize, (double)u2, (double)v2);
            instance.addVertexWithUV((double)(-sunSize), 100.0, (double)sunSize, (double)u1, (double)v2);
            return;
        }
        if (StackEm.getContainerInstance().hasCustomMoon() && y == -100.0) {
            if (this.stackem$moonTrigger1) {
                return;
            }
            this.stackem$moonTrigger1 = true;
            DeepMeta deepMeta = StackEm.getContainerInstance().getDeepMeta();
            int moonPhase = deepMeta.getMoonCycle(this.worldObj.getWorldTime());
            int amX = deepMeta.moonData.number_x;
            int amY = deepMeta.moonData.number_y;
            float moonSize = deepMeta.getMoonScale();
            int phaseX = moonPhase % amX;
            int phaseY = moonPhase / amX % amY;
            float u1 = (float)phaseX / (float)amX;
            float v1 = (float)phaseY / (float)amY;
            float u2 = (float)(phaseX + 1) / (float)amX;
            float v2 = (float)(phaseY + 1) / (float)amY;
            instance.addVertexWithUV((double)(-moonSize), -100.0, (double)moonSize, (double)u2, (double)v2);
            instance.addVertexWithUV((double)moonSize, -100.0, (double)moonSize, (double)u1, (double)v2);
            instance.addVertexWithUV((double)moonSize, -100.0, (double)(-moonSize), (double)u1, (double)v1);
            instance.addVertexWithUV((double)(-moonSize), -100.0, (double)(-moonSize), (double)u2, (double)v1);
            return;
        }
        instance.addVertexWithUV(x, y, z, u, v);
    }

    @Inject(method={"renderSky"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/world/Tessellator;draw()V")})
    private void stackem$hijackMoonRevert(float deltaTicks, CallbackInfo ci) {
        if (this.stackem$sunTrigger1) {
            this.stackem$sunTrigger1 = false;
        }
        if (this.stackem$moonTrigger1) {
            this.stackem$moonTrigger1 = false;
        }
    }
}

