/*
 * Decompiled with CFR 0.152.
 */
package net.tracystacktrace.stackem.modifications;

import com.google.gson.JsonObject;
import java.awt.image.BufferedImage;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.world.RenderEngine;
import net.tracystacktrace.stackem.StackEm;
import net.tracystacktrace.stackem.hacks.SmartHacks;
import net.tracystacktrace.stackem.impl.TexturePackStacked;
import net.tracystacktrace.stackem.modifications.imageglue.GlueImages;
import net.tracystacktrace.stackem.modifications.imageglue.segment.SegmentedTexture;
import net.tracystacktrace.stackem.modifications.imageglue.segment.SegmentsProvider;
import net.tracystacktrace.stackem.modifications.moon.CelestialMeta;
import net.tracystacktrace.stackem.modifications.moon.MoonReader;
import net.tracystacktrace.stackem.sagittarius.IconProcessorException;
import net.tracystacktrace.stackem.sagittarius.IconSwapReader;
import net.tracystacktrace.stackem.sagittarius.ItemIconSwap;
import net.tracystacktrace.stackem.sagittarius.SagittariusBridge;
import net.tracystacktrace.stackem.tools.IOReadHelper;
import net.tracystacktrace.stackem.tools.ZipFileHelper;

public final class StackEmModifications {
    public static void fetchTextureModifications() {
        StackEmModifications.fetchTextureModifications(Minecraft.getInstance().renderEngine);
    }

    public static void fetchIconModifications() {
        StackEmModifications.fetchIconModifications(Minecraft.getInstance().renderEngine);
    }

    public static void fetchTextureModifications(RenderEngine renderEngine) {
        String content;
        if (renderEngine == null || StackEm.DEBUG_FORCE_FALLBACK) {
            return;
        }
        TexturePackStacked stacked = StackEm.getContainerInstance();
        if (stacked.isEmpty()) {
            return;
        }
        for (SegmentedTexture value : SegmentsProvider.TEXTURES) {
            BufferedImage image = GlueImages.processLayering(value);
            if (SmartHacks.getTextureMap(renderEngine).containsKey((Object)value.texture())) {
                int id = SmartHacks.getTextureMap(renderEngine).getInt((Object)value.texture());
                renderEngine.setupTexture(image, id);
                continue;
            }
            int loc = renderEngine.allocateAndSetupTexture(image);
            SmartHacks.getTextureMap(renderEngine).put((Object)value.texture(), loc);
        }
        if (stacked.checkIfFileExists("/stackem.moon.json")) {
            try {
                content = IOReadHelper.readTextFile("/stackem.moon.json", arg_0 -> ((TexturePackStacked)stacked).getResourceAsStream(arg_0));
                JsonObject object = IOReadHelper.processJson(content);
                CelestialMeta compiled = MoonReader.fromJson(object);
                stacked.getDeepMeta().setMoonData(compiled);
            }
            catch (IOReadHelper.CustomIOException e) {
                StackEm.LOGGER.severe("Failed fetching and compiling contents of stackem.moon.json");
                StackEm.LOGGER.throwing("StackEmModifications", "fetchTextureModifications", e);
                e.printStackTrace();
            }
        }
        if (stacked.checkIfFileExists("/stackem.sun.json")) {
            try {
                content = IOReadHelper.readTextFile("/stackem.sun.json", arg_0 -> ((TexturePackStacked)stacked).getResourceAsStream(arg_0));
                JsonObject object = IOReadHelper.processJson(content);
                CelestialMeta compiled = MoonReader.fromJson(object);
                stacked.getDeepMeta().setMoonData(compiled);
            }
            catch (IOReadHelper.CustomIOException e) {
                StackEm.LOGGER.severe("Failed fetching and compiling contents of stackem.sun.json");
                StackEm.LOGGER.throwing("StackEmModifications", "fetchTextureModifications", e);
                e.printStackTrace();
            }
        }
    }

    public static void fetchIconModifications(RenderEngine render) {
        if (render == null || StackEm.DEBUG_FORCE_FALLBACK) {
            return;
        }
        TexturePackStacked stacked = StackEm.getContainerInstance();
        if (stacked.isEmpty()) {
            return;
        }
        for (ZipFile file : stacked.getZipFiles()) {
            ZipEntry entry = ZipFileHelper.getEntryFor(file, "stackem.items.json");
            if (entry == null) continue;
            try {
                ItemIconSwap[] possible;
                for (ItemIconSwap item : possible = IconSwapReader.fromJson(file.getName() + "!/stackem.items.json", ZipFileHelper.readTextFile(file, entry))) {
                    SagittariusBridge.addIconSwapper(item);
                }
            }
            catch (ZipFileHelper.ZipIOException e) {
                StackEm.LOGGER.severe(String.format("Failed to read file: %s", file.getName() + "!/stackem.items.json"));
                StackEm.LOGGER.throwing("StackEmModifications", "fetchIconModifications", e);
            }
            catch (IconProcessorException e) {
                StackEm.LOGGER.severe(String.format("Failed during compiling icon swapper of %s", file.getName() + "!/stackem.items.json"));
                StackEm.LOGGER.throwing("StackEmModifications", "fetchIconModifications", e);
                e.printStackTrace();
            }
        }
    }
}

