/*
 * Decompiled with CFR 0.152.
 */
package net.tracystacktrace.stackem.modifications.moon;

import net.tracystacktrace.stackem.tools.QuickRNG;
import org.jetbrains.annotations.Nullable;

public enum EnumCelestialCycle {
    STATIC("static"),
    DEFAULT("default"),
    REVERSE("reverse"),
    RANDOM("random");

    public final String id;

    private EnumCelestialCycle(String id) {
        this.id = id;
    }

    public static int getMoon(EnumCelestialCycle cycle, long timeTicks, int total) {
        switch (cycle.ordinal()) {
            case 0: {
                return 0;
            }
            case 1: {
                return (int)(timeTicks / 24000L) % total;
            }
            case 2: {
                int phase = (int)(timeTicks / 24000L) % total;
                return (total - phase) % total;
            }
            case 3: {
                return QuickRNG.getBetween((int)(timeTicks / 24000L), 0, total);
            }
        }
        return -1;
    }

    @Nullable
    public static EnumCelestialCycle getType(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        for (EnumCelestialCycle cycle : EnumCelestialCycle.values()) {
            if (!cycle.id.equalsIgnoreCase(name)) continue;
            return cycle;
        }
        return null;
    }
}

