/*
 * Decompiled with CFR 0.152.
 */
package net.tracystacktrace.stackem.modifications.moon;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.tracystacktrace.stackem.modifications.moon.CelestialMeta;
import net.tracystacktrace.stackem.modifications.moon.EnumCelestialCycle;
import net.tracystacktrace.stackem.tools.JsonReadHelper;
import org.jetbrains.annotations.NotNull;

public final class MoonReader {
    @NotNull
    public static CelestialMeta fromJson(@NotNull JsonObject object) {
        JsonElement elementY;
        Integer contentY;
        JsonElement elementX;
        Integer contentX;
        JsonElement elementScale;
        Float contentScale;
        EnumCelestialCycle cycleType;
        JsonElement elementCycle;
        String contentCycle;
        JsonElement elementPath;
        Object contentPath;
        String texture_path = "/textures/environment/moon_phases.png";
        EnumCelestialCycle cycle = EnumCelestialCycle.DEFAULT;
        float scale = 1.0f;
        int number_x = 4;
        int number_y = 2;
        if (object.has("path") && (contentPath = JsonReadHelper.readString(elementPath = object.get("path"))) != null && !((String)contentPath).isEmpty()) {
            if (!((String)contentPath).startsWith("/")) {
                contentPath = "/" + (String)contentPath;
            }
            texture_path = contentPath;
        }
        if (object.has("cycle") && (contentCycle = JsonReadHelper.readString(elementCycle = object.get("cycle"))) != null && !contentCycle.isEmpty() && (cycleType = EnumCelestialCycle.getType(contentCycle)) != null) {
            cycle = cycleType;
        }
        if (object.has("scale") && (contentScale = JsonReadHelper.readFloat(elementScale = object.get("scale"))) != null && contentScale.floatValue() > 0.0f && contentScale.floatValue() <= 128.0f) {
            scale = contentScale.floatValue();
        }
        if (object.has("number_x") && (contentX = JsonReadHelper.readInteger(elementX = object.get("number_x"))) != null && contentX > 0) {
            number_x = contentX;
        }
        if (object.has("number_y") && (contentY = JsonReadHelper.readInteger(elementY = object.get("number_y"))) != null && contentY > 0) {
            number_y = contentY;
        }
        return new CelestialMeta(texture_path, cycle, scale, number_x, number_y);
    }
}

