/*
 * Decompiled with CFR 0.152.
 */
package net.tracystacktrace.stackem.sagittarius;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import net.minecraft.common.block.icon.Icon;
import net.minecraft.common.block.icon.IconRegister;
import net.minecraft.common.item.ItemStack;
import net.minecraft.common.item.Items;
import net.tracystacktrace.stackem.sagittarius.IconProcessorException;
import net.tracystacktrace.stackem.sagittarius.swap.SwapDescriptor;
import net.tracystacktrace.stackem.sagittarius.swap.TextureByMetadata;
import net.tracystacktrace.stackem.sagittarius.swap.TextureByName;
import net.tracystacktrace.stackem.tools.JsonReadHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ItemIconSwap(int target, @NotNull TextureByName @Nullable [] textureByNames, @NotNull TextureByMetadata @Nullable [] textureByMetadata) {
    @Nullable
    public Icon getIcon(@NotNull ItemStack stack) {
        int i;
        if (this.hasAnyMetaSwaps()) {
            for (i = 0; i < this.textureByMetadata.length; ++i) {
                TextureByMetadata meta = this.textureByMetadata[i];
                if (!meta.compare(stack.getItemDamage())) continue;
                return meta.textureIcon;
            }
        }
        if (this.hasAnyNameSwaps()) {
            for (i = 0; i < this.textureByNames.length; ++i) {
                TextureByName name = this.textureByNames[i];
                if (!name.compareString(stack.getDisplayName())) continue;
                return name.textureIcon;
            }
        }
        return null;
    }

    @Nullable
    public String getArmorTexture(@NotNull ItemStack stack) {
        int i;
        if (this.hasAnyMetaSwaps()) {
            for (i = 0; i < this.textureByMetadata.length; ++i) {
                TextureByMetadata meta = this.textureByMetadata[i];
                if (!meta.hasArmorTexture() || !meta.compare(stack.getItemDamage())) continue;
                return meta.getArmorTexture();
            }
        }
        if (this.hasAnyNameSwaps()) {
            for (i = 0; i < this.textureByNames.length; ++i) {
                TextureByName name = this.textureByNames[i];
                if (!name.hasArmorTexture() || !name.compareString(stack.getDisplayName())) continue;
                return name.getArmorTexture();
            }
        }
        return null;
    }

    public void registerIcon(@NotNull IconRegister register) {
        if (this.hasAnyMetaSwaps()) {
            for (SwapDescriptor swapDescriptor : this.textureByMetadata) {
                swapDescriptor.registerIcon(register);
            }
        }
        if (this.hasAnyNameSwaps()) {
            for (SwapDescriptor swapDescriptor : this.textureByNames) {
                swapDescriptor.registerIcon(register);
            }
        }
    }

    public boolean hasAnyNameSwaps() {
        return this.textureByNames != null && this.textureByNames.length > 0;
    }

    public boolean hasAnyMetaSwaps() {
        return this.textureByMetadata != null && this.textureByMetadata.length > 0;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemIconSwap that = (ItemIconSwap)o;
        return this.target == that.target && Objects.deepEquals(this.textureByNames, that.textureByNames) && Objects.deepEquals(this.textureByMetadata, that.textureByMetadata);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.target, Arrays.hashCode(this.textureByNames), Arrays.hashCode(this.textureByMetadata));
    }

    @NotNull
    public static ItemIconSwap fromJson(@NotNull JsonObject object) throws IconProcessorException {
        JsonElement onMetaElement;
        JsonElement onNameElement;
        int targetItemID = -1;
        if (!object.has("item")) {
            throw new IconProcessorException(2);
        }
        JsonElement itemElement = object.get("item");
        if (itemElement.isJsonPrimitive()) {
            JsonPrimitive itemPrimitive = itemElement.getAsJsonPrimitive();
            if (itemPrimitive.isNumber()) {
                int item_iid = itemPrimitive.getAsInt();
                if (ItemIconSwap.isValidItemID(item_iid)) {
                    targetItemID = item_iid;
                }
            } else if (itemPrimitive.isString()) {
                String item_iid = itemPrimitive.getAsString();
                targetItemID = ItemIconSwap.getItemIDByName(item_iid);
            }
        }
        if (targetItemID == -1) {
            throw new IconProcessorException(3, String.valueOf(targetItemID));
        }
        TextureByName[] textureByNames = null;
        TextureByMetadata[] textureByMetadata = null;
        if (object.has("onName") && (onNameElement = object.get("onName")).isJsonArray()) {
            try {
                textureByNames = JsonReadHelper.transformArray(onNameElement.getAsJsonArray(), TextureByName::fromJson, TextureByName[]::new);
            }
            catch (IconProcessorException e) {
                throw new IconProcessorException(5, onNameElement.toString(), e);
            }
        }
        if (object.has("onMeta") && (onMetaElement = object.get("onMeta")).isJsonArray()) {
            try {
                textureByMetadata = JsonReadHelper.transformArray(onMetaElement.getAsJsonArray(), TextureByMetadata::fromJson, TextureByMetadata[]::new);
            }
            catch (IconProcessorException e) {
                throw new IconProcessorException(6, onMetaElement.toString(), e);
            }
        }
        if (textureByNames != null) {
            Arrays.sort(textureByNames, Comparator.comparingInt(SwapDescriptor::getPriority));
        }
        if (textureByMetadata != null) {
            Arrays.sort(textureByMetadata, Comparator.comparingInt(SwapDescriptor::getPriority));
        }
        return new ItemIconSwap(targetItemID, textureByNames, textureByMetadata);
    }

    private static boolean isValidItemID(int i) {
        if (i < 0 || i >= Items.ITEMS_LIST.length) {
            return false;
        }
        try {
            return Items.ITEMS_LIST[i] != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static int getItemIDByName(@Nullable String candidate) {
        if (candidate == null || candidate.isEmpty()) {
            return -1;
        }
        return Arrays.stream(Items.ITEMS_LIST).filter(Objects::nonNull).filter(i -> i.getItemName().equals(candidate)).map(i -> i.itemID).findFirst().orElse(-1);
    }
}

