/*
 * Decompiled with CFR 0.152.
 */
package net.tracystacktrace.stackem.sagittarius;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.common.block.icon.Icon;
import net.minecraft.common.block.icon.IconRegister;
import net.minecraft.common.item.ItemStack;
import net.tracystacktrace.stackem.sagittarius.ItemIconSwap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SagittariusBridge {
    private static final Int2ObjectMap<List<ItemIconSwap>> mapTexturepacksSwap = new Int2ObjectOpenHashMap();

    @Nullable
    public static Icon getCustomIcon(@NotNull ItemStack stack) {
        List candidates = (List)mapTexturepacksSwap.get(stack.getItemID());
        if (candidates == null || candidates.isEmpty()) {
            return null;
        }
        for (int i = 0; i < candidates.size(); ++i) {
            Icon icon = ((ItemIconSwap)candidates.get(i)).getIcon(stack);
            if (icon == null) continue;
            return icon;
        }
        return null;
    }

    @Nullable
    public static String getCustomArmor(@NotNull ItemStack stack) {
        List candidates = (List)mapTexturepacksSwap.get(stack.getItemID());
        if (candidates == null || candidates.isEmpty()) {
            return null;
        }
        for (int i = 0; i < candidates.size(); ++i) {
            String icon = ((ItemIconSwap)candidates.get(i)).getArmorTexture(stack);
            if (icon == null) continue;
            return icon;
        }
        return null;
    }

    public static void registerAllIcons(@NotNull IconRegister register) {
        for (List listSwaps : mapTexturepacksSwap.values()) {
            for (ItemIconSwap single : listSwaps) {
                single.registerIcon(register);
            }
        }
    }

    public static boolean containsIconSwapper(int itemID) {
        return mapTexturepacksSwap.containsKey(itemID);
    }

    public static void addIconSwapper(@NotNull ItemIconSwap set) {
        if (!mapTexturepacksSwap.containsKey(set.target())) {
            mapTexturepacksSwap.put(set.target(), new ArrayList());
        }
        ((List)mapTexturepacksSwap.get(set.target())).add(set);
        System.out.println(String.format("Added custom swap for target [%s] of \"onName\" number %s, \"onMeta\" number %s", set.target(), set.textureByNames() != null ? Integer.valueOf(set.textureByNames().length) : "null", set.textureByMetadata() != null ? Integer.valueOf(set.textureByMetadata().length) : "null"));
    }

    public static void clearAll() {
        mapTexturepacksSwap.forEach((i, s) -> s.clear());
        mapTexturepacksSwap.clear();
    }
}

