/*
 * Decompiled with CFR 0.152.
 */
package net.tracystacktrace.stackem.sagittarius.swap;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.common.block.icon.Icon;
import net.minecraft.common.block.icon.IconRegister;
import net.tracystacktrace.stackem.sagittarius.IconProcessorException;
import net.tracystacktrace.stackem.tools.JsonReadHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SwapDescriptor {
    public final String texturePath;
    public final int priority;
    public Icon textureIcon;
    protected String armorTexture = null;
    protected boolean armorEnableColor = true;

    public SwapDescriptor(@NotNull String texturePath, int priority) {
        this.texturePath = texturePath;
        this.priority = priority;
    }

    public void registerIcon(@NotNull IconRegister register) {
        this.textureIcon = register.registerIcon(this.texturePath);
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean hasArmorTexture() {
        return this.armorTexture != null;
    }

    public boolean hasArmorColor() {
        return this.armorEnableColor;
    }

    public void setArmorColor(boolean b) {
        this.armorEnableColor = b;
    }

    @Nullable
    public String getArmorTexture() {
        return this.armorTexture;
    }

    public void setArmorTexture(@NotNull String s) {
        this.armorTexture = s;
    }

    @NotNull
    public static String obtainTexture(@NotNull JsonObject object) throws IconProcessorException {
        if (object.has("texture")) {
            JsonElement element = object.get("texture");
            String content = JsonReadHelper.readString(element);
            if (content != null) {
                return content;
            }
            throw new IconProcessorException(7, element.toString());
        }
        throw new IconProcessorException(8);
    }

    public static int obtainPriority(@NotNull JsonObject object) throws IconProcessorException {
        if (object.has("priority")) {
            JsonElement element = object.get("priority");
            Integer content = JsonReadHelper.readInteger(element);
            if (content != null) {
                return content;
            }
            throw new IconProcessorException(9, element.toString());
        }
        return 0;
    }

    public static void obtainArmorAdditionally(@NotNull SwapDescriptor swapper, @NotNull JsonObject object) throws IconProcessorException {
        Object content;
        JsonElement element;
        if (object.has("armorTexture")) {
            element = object.get("armorTexture");
            content = JsonReadHelper.readString(element);
            if (content != null) {
                swapper.setArmorTexture((String)content);
            } else {
                throw new IconProcessorException(11, element.toString());
            }
        }
        if (object.has("armorEnableColor")) {
            element = object.get("armorEnableColor");
            content = JsonReadHelper.readBoolean(element);
            if (content != null) {
                swapper.setArmorColor((Boolean)content);
            } else {
                throw new IconProcessorException(12, element.toString());
            }
        }
    }
}

