/*
 * Decompiled with CFR 0.152.
 */
package net.tracystacktrace.stackem.sagittarius.swap;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.tracystacktrace.stackem.sagittarius.IconProcessorException;
import net.tracystacktrace.stackem.sagittarius.swap.SwapDescriptor;
import net.tracystacktrace.stackem.tools.JsonReadHelper;
import org.jetbrains.annotations.NotNull;

public class TextureByMetadata
extends SwapDescriptor {
    public static final byte STATIC = 0;
    public static final byte BETWEEN = 1;
    public static final byte BELOW = 2;
    public static final byte AFTER = 3;
    public static final byte FOLLOWING = 4;
    public final byte compareCode;
    public final int[] compareInts;

    public TextureByMetadata(byte compareCode, int @NotNull [] compareInts, @NotNull String texturePath, int priority) {
        super(texturePath, priority);
        this.compareCode = compareCode;
        this.compareInts = compareInts;
    }

    public boolean compare(int meta) {
        switch (this.compareCode) {
            case 0: {
                return this.compareInts[0] == meta;
            }
            case 1: {
                return this.compareInts[0] <= meta && this.compareInts[1] >= meta;
            }
            case 2: {
                return this.compareInts[0] < meta;
            }
            case 3: {
                return this.compareInts[0] > meta;
            }
            case 4: {
                for (int i = 0; i < this.compareInts.length; ++i) {
                    if (this.compareInts[i] != meta) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    @NotNull
    public static TextureByMetadata fromJson(@NotNull JsonObject object) throws IconProcessorException {
        JsonElement inputElement;
        byte compareCode = -1;
        int[] compareInts = null;
        if (object.has("static") && (inputElement = object.get("static")).isJsonPrimitive() && inputElement.getAsJsonPrimitive().isNumber()) {
            compareCode = 0;
            compareInts = new int[]{inputElement.getAsInt()};
        }
        if (object.has("between") && (inputElement = object.get("between")).isJsonArray()) {
            compareCode = 1;
            try {
                compareInts = JsonReadHelper.readIntArray(inputElement.getAsJsonArray());
            }
            catch (IllegalStateException e) {
                throw new IconProcessorException(4, inputElement.toString(), e);
            }
        }
        if (object.has("below") && (inputElement = object.get("below")).isJsonPrimitive() && inputElement.getAsJsonPrimitive().isNumber()) {
            compareCode = 2;
            compareInts = new int[]{inputElement.getAsInt()};
        }
        if (object.has("after") && (inputElement = object.get("after")).isJsonPrimitive() && inputElement.getAsJsonPrimitive().isNumber()) {
            compareCode = 3;
            compareInts = new int[]{inputElement.getAsInt()};
        }
        if (object.has("following") && (inputElement = object.get("following")).isJsonArray()) {
            compareCode = 4;
            try {
                compareInts = JsonReadHelper.readIntArray(inputElement.getAsJsonArray());
            }
            catch (IllegalStateException e) {
                throw new IconProcessorException(4, inputElement.toString(), e);
            }
        }
        if (compareCode == -1) {
            throw new IconProcessorException(4);
        }
        String texture = SwapDescriptor.obtainTexture(object);
        int priority = SwapDescriptor.obtainPriority(object);
        TextureByMetadata compiled = new TextureByMetadata(compareCode, compareInts, texture, priority);
        SwapDescriptor.obtainArmorAdditionally(compiled, object);
        return compiled;
    }
}

