/*
 * Decompiled with CFR 0.152.
 */
package net.tracystacktrace.stackem.sagittarius.swap;

import com.google.gson.JsonObject;
import net.tracystacktrace.stackem.sagittarius.IconProcessorException;
import net.tracystacktrace.stackem.sagittarius.swap.SwapDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextureByName
extends SwapDescriptor {
    public static final byte EQUALS = 0;
    public static final byte EQUALS_IGNORE_CASE = 1;
    public static final byte CONTAINS = 2;
    public static final byte REGEX = 3;
    public static final byte STARTS_WITH = 4;
    public static final byte ENDS_WITH = 5;
    public final byte compareCode;
    public final String targetString;

    public TextureByName(byte compareCode, @NotNull String targetString, @NotNull String texturePath, int priority) {
        super(texturePath, priority);
        this.compareCode = compareCode;
        this.targetString = targetString;
    }

    public boolean compareString(@Nullable String itemName) {
        if (itemName == null || itemName.isEmpty()) {
            return false;
        }
        switch (this.compareCode) {
            case 0: {
                return itemName.equals(this.targetString);
            }
            case 1: {
                return itemName.equalsIgnoreCase(this.targetString);
            }
            case 2: {
                return itemName.contains(this.targetString);
            }
            case 4: {
                return itemName.startsWith(this.targetString);
            }
            case 5: {
                return itemName.endsWith(this.targetString);
            }
        }
        return false;
    }

    @NotNull
    public static TextureByName fromJson(@NotNull JsonObject object) throws IconProcessorException {
        byte compareCode = -1;
        String targetString = null;
        if (object.has("equals")) {
            targetString = object.get("equals").getAsString();
            compareCode = 0;
        }
        if (object.has("equalsIgnoreCase")) {
            targetString = object.get("equalsIgnoreCase").getAsString();
            compareCode = 1;
        }
        if (object.has("contains")) {
            targetString = object.get("contains").getAsString();
            compareCode = 2;
        }
        if (object.has("startsWith")) {
            targetString = object.get("startsWith").getAsString();
            compareCode = 4;
        }
        if (object.has("endsWith")) {
            targetString = object.get("endsWith").getAsString();
            compareCode = 5;
        }
        if (compareCode == -1 || targetString == null) {
            throw new IconProcessorException(4);
        }
        String texture = SwapDescriptor.obtainTexture(object);
        int priority = SwapDescriptor.obtainPriority(object);
        TextureByName compiled = new TextureByName(compareCode, targetString, texture, priority);
        SwapDescriptor.obtainArmorAdditionally(compiled, object);
        return compiled;
    }
}

