/*
 * Decompiled with CFR 0.152.
 */
package net.tracystacktrace.stackem.tools;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.stream.Collectors;
import net.tracystacktrace.stackem.tools.FunctionWithException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IOReadHelper {
    @NotNull
    public static String readTextFile(@NotNull String path, @NotNull @NotNull FunctionWithException<@NotNull String, @NotNull InputStream, IOException> access) throws CustomIOException {
        String collected;
        InputStream inputStream;
        try {
            inputStream = access.apply(path);
        }
        catch (IOException e) {
            throw new CustomIOException(0, path, e);
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            collected = reader.lines().collect(Collectors.joining());
        }
        catch (IOException e) {
            throw new CustomIOException(1, path, e);
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return collected;
    }

    @NotNull
    public static JsonObject processJson(@NotNull String content) throws CustomIOException {
        try {
            return JsonParser.parseString((String)content).getAsJsonObject();
        }
        catch (JsonParseException e) {
            throw new CustomIOException(2, content, (Exception)((Object)e));
        }
    }

    public static class CustomIOException
    extends Exception {
        public static final byte ERROR_DURING_IS_FETCH = 0;
        public static final byte ERROR_DURING_IO_OPERATION = 1;
        public static final byte ERROR_PARSE_JSON = 2;

        @NotNull
        public static String getErrorCode(byte code, @Nullable String optional) {
            return switch (code) {
                case 0 -> String.format("Error during accessing an InputStream instance of %s", optional);
                case 1 -> String.format("Error during reading the file of %s", optional);
                case 2 -> String.format("Error during JSON parse of: %s", optional);
                default -> "Unknown error!";
            };
        }

        public CustomIOException(byte code, @Nullable String optional, @Nullable Exception e) {
            super(CustomIOException.getErrorCode(code, optional), e);
        }
    }
}

