/*
 * Decompiled with CFR 0.152.
 */
package net.tracystacktrace.stackem.tools;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.function.Function;
import net.tracystacktrace.stackem.tools.FunctionWithException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsonReadHelper {
    public static int @NotNull [] readIntArray(@NotNull JsonArray array) throws IllegalStateException {
        int[] result = new int[array.size()];
        for (int i = 0; i < result.length; ++i) {
            JsonElement element = array.get(i);
            if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isNumber()) {
                throw new IllegalStateException(String.format("A presumably pure int[] json array is not pure! Failed at index: %s", i));
            }
            result[i] = element.getAsInt();
        }
        return result;
    }

    public static <T, E extends Exception> T @NotNull [] transformArray(@NotNull JsonArray array, @NotNull @NotNull FunctionWithException<@NotNull JsonObject, @NotNull T, E> transformer, @NotNull @NotNull Function<Integer, T @NotNull []> emptyArray) throws E {
        HashSet<T> collector = new HashSet<T>();
        for (JsonElement candidate : array) {
            if (!candidate.isJsonObject()) continue;
            T value = transformer.apply(candidate.getAsJsonObject());
            collector.add(value);
        }
        return collector.toArray(emptyArray.apply(0));
    }

    public static <T> T @NotNull [] transformArraySafe(@NotNull JsonArray array, @NotNull @NotNull Function<@NotNull JsonElement, @Nullable T> transformer, @NotNull @NotNull Function<Integer, T @NotNull []> emptyArray) {
        HashSet<T> collector = new HashSet<T>();
        for (JsonElement candidate : array) {
            T value = transformer.apply(candidate);
            if (value == null) continue;
            collector.add(value);
        }
        return collector.toArray(emptyArray.apply(0));
    }

    @Nullable
    public static String readString(@NotNull JsonElement element) {
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
            return element.getAsString();
        }
        return null;
    }

    @Nullable
    public static Integer readInteger(@NotNull JsonElement element) {
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isNumber()) {
            return element.getAsInt();
        }
        return null;
    }

    @Nullable
    public static Float readFloat(@NotNull JsonElement element) {
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isNumber()) {
            return Float.valueOf(element.getAsFloat());
        }
        return null;
    }

    @Nullable
    public static Boolean readBoolean(@NotNull JsonElement element) {
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isBoolean()) {
            return element.getAsBoolean();
        }
        return null;
    }
}

