/*
 * Decompiled with CFR 0.152.
 */
package net.tracystacktrace.stackem;

import com.fox2code.foxloader.loader.Mod;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.common.util.i18n.StringTranslate;
import net.tracystacktrace.stackem.impl.TagTexturePack;
import net.tracystacktrace.stackem.impl.TexturePackStacked;
import net.tracystacktrace.stackem.processor.category.DescriptionFileCooker;

public class StackEm
extends Mod {
    public static boolean DEBUG_DISABLE = false;
    public static final Logger LOGGER = Logger.getLogger("STACKEM");

    public static TexturePackStacked getContainerInstance() {
        return (TexturePackStacked)Minecraft.getInstance().texturePackList.getSelectedTexturePack();
    }

    public static void toggleDebug() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.thePlayer == null) {
            return;
        }
        DEBUG_DISABLE = !DEBUG_DISABLE;
        mc.renderEngine.refreshTextures();
        mc.thePlayer.addChatMessage(StringTranslate.getInstance().translateKey(DEBUG_DISABLE ? "stackem.debug.on" : "stackem.debug.off"));
    }

    public static String[] unpackSaveString(String input) {
        int start = input.indexOf(123);
        int end = input.indexOf(125);
        if (start == -1 || end == -1 || !input.contains("stackem")) {
            return new String[0];
        }
        return input.substring(start + 1, end).split(";");
    }

    public static String packSaveString(String[] input) {
        if (input == null || input.length < 1) {
            return "stackem{}";
        }
        return "stackem{" + String.join((CharSequence)";", input) + "}";
    }

    public static boolean isValidWebsite(String website) {
        return website != null && (website.startsWith("https://") || website.startsWith("http://"));
    }

    public static List<TagTexturePack> buildTexturePackList() {
        File texturepacksDir = new File(Minecraft.getInstance().getMinecraftDir(), "texturepacks");
        if (!texturepacksDir.exists() || !texturepacksDir.isDirectory()) {
            return null;
        }
        ArrayList<TagTexturePack> collector = new ArrayList<TagTexturePack>();
        for (File file : texturepacksDir.listFiles()) {
            TagTexturePack tagTexturePack = StackEm.processFile(file);
            if (tagTexturePack == null) continue;
            collector.add(tagTexturePack);
        }
        return collector;
    }

    public static TagTexturePack processFile(File file) {
        Object[] collect$1 = StackEm.fetchDefaultObjects(file);
        if (collect$1 == null) {
            return null;
        }
        if (collect$1[0] == null || ((String)collect$1[0]).isEmpty()) {
            collect$1[0] = "";
        }
        if (collect$1[1] == null || ((String)collect$1[1]).isEmpty()) {
            collect$1[1] = "";
        }
        TagTexturePack tagTexturePack = new TagTexturePack(file, file.getName(), (String)collect$1[0], (String)collect$1[1]);
        if (collect$1[2] != null) {
            tagTexturePack.setThumbnail((BufferedImage)collect$1[2]);
        }
        if (collect$1[3] != null) {
            DescriptionFileCooker.read(tagTexturePack, (String)collect$1[3]);
        }
        return tagTexturePack;
    }

    private static Object[] fetchDefaultObjects(File file) {
        Object[] objects = new Object[4];
        boolean canBeAdded = false;
        try {
            ZipEntry stackemJson;
            ZipEntry packPng;
            ZipFile zipFile = new ZipFile(file);
            ZipEntry packTxt = zipFile.getEntry("pack.txt");
            if (packTxt != null) {
                try (InputStream inputStream2 = zipFile.getInputStream(packTxt);
                     BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream2));){
                    objects[0] = reader.readLine();
                    objects[1] = reader.readLine();
                    canBeAdded = true;
                }
                catch (IOException inputStream2) {
                    // empty catch block
                }
            }
            if ((packPng = zipFile.getEntry("pack.png")) != null) {
                try (InputStream inputStream3 = zipFile.getInputStream(packPng);){
                    objects[2] = ImageIO.read(inputStream3);
                    canBeAdded = true;
                }
                catch (IOException inputStream3) {
                    // empty catch block
                }
            }
            if ((stackemJson = zipFile.getEntry("stackem.json")) != null) {
                try (InputStream inputStream = zipFile.getInputStream(stackemJson);
                     BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
                    objects[3] = reader.lines().collect(Collectors.joining());
                    canBeAdded = true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            zipFile.close();
            return canBeAdded ? objects : null;
        }
        catch (IOException e) {
            return null;
        }
    }
}

