/*
 * Decompiled with CFR 0.152.
 */
package net.tracystacktrace.stackem.mixins;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.ITexturePack;
import net.minecraft.client.renderer.block.TexturePackList;
import net.tracystacktrace.stackem.StackEm;
import net.tracystacktrace.stackem.impl.TexturePackStacked;
import net.tracystacktrace.stackem.tools.QuickRNG;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TexturePackList.class})
public abstract class MixinTexturePackList {
    @Shadow
    private ITexturePack selectedTexturePack;
    @Shadow
    @Final
    private static ITexturePack defaultTexturePack;
    @Shadow
    @Final
    private Minecraft mc;

    @Shadow
    protected abstract List<File> getTexturePackDirContents();

    @Inject(method={"updateAvaliableTexturePacks"}, at={@At(value="HEAD")}, cancellable=true)
    private void stackem$injectReplaceLoader(CallbackInfo ci) {
        this.selectedTexturePack = defaultTexturePack;
        ArrayList<File> collector = new ArrayList<File>();
        if (this.mc.gameSettings.texturePack.startsWith("stackem")) {
            String[] candidates = StackEm.unpackSaveString(this.mc.gameSettings.texturePack);
            List<File> files = this.getTexturePackDirContents();
            Arrays.stream(candidates).map(c -> files.stream().filter(f -> f.getName().toLowerCase().endsWith(".zip")).filter(f -> f.getName().contains((CharSequence)c)).findFirst().orElse(null)).filter(Objects::nonNull).forEach(collector::add);
        }
        String[] finished = new String[collector.size()];
        for (int i = 0; i < collector.size(); ++i) {
            finished[i] = ((File)collector.get(i)).getName();
        }
        this.selectedTexturePack = new TexturePackStacked(QuickRNG.getRandomIdentifier(), defaultTexturePack, collector);
        this.mc.gameSettings.texturePack = StackEm.packSaveString(finished);
        this.mc.gameSettings.saveOptions();
        ci.cancel();
    }
}

