/*
 * Decompiled with CFR 0.152.
 */
package net.tracystacktrace.stackem.processor;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.world.RenderEngine;
import net.tracystacktrace.stackem.StackEm;
import net.tracystacktrace.stackem.hack.SmartHacks;
import net.tracystacktrace.stackem.impl.TexturePackStacked;
import net.tracystacktrace.stackem.processor.IJam;
import net.tracystacktrace.stackem.processor.imageglue.GlueImages;
import net.tracystacktrace.stackem.processor.imageglue.segment.SegmentedTexture;
import net.tracystacktrace.stackem.processor.imageglue.segment.SegmentsProvider;
import net.tracystacktrace.stackem.processor.moon.JamMoonTexture;
import net.tracystacktrace.stackem.processor.moon.JamSunTexture;

public final class StackEmModifications {
    public static final IJam[] JAMS = new IJam[]{new JamMoonTexture(), new JamSunTexture()};

    public static void fetchTextureModifications() {
        StackEmModifications.fetchTextureModifications(Minecraft.getInstance().renderEngine);
    }

    public static void fetchTextureModifications(RenderEngine renderEngine) {
        if (renderEngine == null) {
            return;
        }
        TexturePackStacked stacked = StackEm.getContainerInstance();
        if (stacked.isEmpty()) {
            return;
        }
        for (SegmentedTexture value : SegmentsProvider.TEXTURES) {
            BufferedImage image = GlueImages.processLayering(value);
            if (SmartHacks.getTextureMap(renderEngine).containsKey((Object)value.texture)) {
                int id = SmartHacks.getTextureMap(renderEngine).getInt((Object)value.texture);
                renderEngine.setupTexture(image, id);
                continue;
            }
            int loc = renderEngine.allocateAndSetupTexture(image);
            SmartHacks.getTextureMap(renderEngine).put((Object)value.texture, loc);
        }
        for (IJam jam : JAMS) {
            if (!stacked.checkIfFileExists(jam.getPath())) continue;
            String collectedJsonString = null;
            try (InputStream inputStream = stacked.getResourceAsStream(jam.getPath());
                 BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
                collectedJsonString = reader.lines().collect(Collectors.joining());
            }
            catch (IOException e) {
                StackEm.LOGGER.severe("Couldn't read file: " + jam.getPath());
                StackEm.LOGGER.throwing("StackEmModifications", "fetchTextureModifications", e);
                continue;
            }
            if (collectedJsonString.isEmpty()) continue;
            jam.process(stacked, collectedJsonString);
            StackEm.LOGGER.info("Loaded JAM: " + jam.getPath());
        }
    }
}

