/*
 * Decompiled with CFR 0.152.
 */
package net.tracystacktrace.stackem.processor.category;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.util.Objects;
import java.util.stream.StreamSupport;
import net.tracystacktrace.stackem.StackEm;
import net.tracystacktrace.stackem.impl.TagTexturePack;
import net.tracystacktrace.stackem.processor.category.EnumCategory;

public class DescriptionFileCooker {
    public static void read(TagTexturePack texturePack, String content) {
        try {
            JsonObject root = JsonParser.parseString((String)content).getAsJsonObject();
            if (root.has("author")) {
                texturePack.setAuthor(root.get("author").getAsString());
            }
            if (root.has("website")) {
                texturePack.setWebsite(root.get("website").getAsString());
            }
            if (root.has("category")) {
                JsonArray customArray;
                EnumCategory[] collected;
                JsonArray idArray;
                JsonObject category = root.get("category").getAsJsonObject();
                if (category.has("id") && !(idArray = category.getAsJsonArray("id")).isEmpty() && (collected = (EnumCategory[])StreamSupport.stream(idArray.spliterator(), false).map(JsonElement::getAsString).map(EnumCategory::define).filter(Objects::nonNull).toArray(EnumCategory[]::new)).length > 0) {
                    texturePack.setCategories(collected);
                }
                if (category.has("custom") && !(customArray = category.getAsJsonArray("custom")).isEmpty() && (collected = (String[])StreamSupport.stream(customArray.spliterator(), false).map(JsonElement::getAsString).filter(Objects::nonNull).filter(e -> !e.isEmpty()).toArray(String[]::new)).length > 0) {
                    texturePack.setCustomCategories((String[])collected);
                }
            }
        }
        catch (JsonParseException e2) {
            StackEm.LOGGER.severe("Failed to process stackem.json for " + texturePack.name);
            StackEm.LOGGER.throwing("DescriptionFileCooker", "read", e2);
        }
    }
}

