/*
 * Decompiled with CFR 0.152.
 */
package net.tracystacktrace.stackem.tools;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public final class StringFeatures {
    public static String limitString(String line, int length, boolean endDots) {
        Object result;
        if (line == null || line.length() < length) {
            return line;
        }
        int maxLength = length;
        int colorCodeCount = (int)line.chars().limit(maxLength - 1).filter(c -> c == 167).count();
        Object object = result = line.length() > (maxLength += colorCodeCount * 2) ? line.substring(0, maxLength) : line;
        if (endDots) {
            result = (String)result + "...";
        }
        return result;
    }

    public static String[] provideCategoryCombinations(List<String> input, int maxLength) {
        ArrayList<String> strings = new ArrayList<String>(input);
        strings.sort(Comparator.comparingInt(String::length));
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<String> currentGroup = new ArrayList<String>();
        int currentGroupLength = 0;
        for (String str : strings) {
            if (str.length() >= maxLength) {
                if (!currentGroup.isEmpty()) {
                    result.add(String.join((CharSequence)" \u00a7r\u00a77|\u00a7r ", currentGroup));
                    currentGroup.clear();
                    currentGroupLength = 0;
                }
                result.add(StringFeatures.truncateString(str, maxLength));
                continue;
            }
            int potentialLength = currentGroupLength + str.length();
            if (!currentGroup.isEmpty()) {
                potentialLength += 3 * currentGroup.size();
            }
            if (potentialLength > maxLength) {
                if (!currentGroup.isEmpty()) {
                    result.add(String.join((CharSequence)" \u00a7r\u00a77|\u00a7r ", currentGroup));
                }
                currentGroup.clear();
                currentGroup.add(str);
                currentGroupLength = str.length();
                continue;
            }
            currentGroup.add(str);
            currentGroupLength += str.length();
        }
        if (!currentGroup.isEmpty()) {
            result.add(String.join((CharSequence)" \u00a7r\u00a77|\u00a7r ", currentGroup));
        }
        return result.toArray(new String[0]);
    }

    private static String truncateString(String str, int maxLength) {
        if (str.length() <= maxLength) {
            return str;
        }
        if (maxLength <= 3) {
            return "...".substring(0, maxLength);
        }
        return str.substring(0, maxLength - 3) + "...";
    }
}

