/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.myfurniture.listeners.optimize;

import com.ssomar.myfurniture.MyFurniture;
import com.ssomar.myfurniture.furniture.activators.Option;
import com.ssomar.myfurniture.listeners.activators.FurnitureBreakListener;
import com.ssomar.myfurniture.listeners.activators.FurniturePlaceListener;
import com.ssomar.myfurniture.listeners.activators.PlayerScrollDownByTargetingListener;
import com.ssomar.myfurniture.listeners.activators.PlayerScrollUpByTargetingListener;
import com.ssomar.score.sobject.sactivator.SOption;
import com.ssomar.score.utils.Couple;
import com.ssomar.sevents.EventName;
import com.ssomar.sevents.registration.DynamicRegistration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class OptimizedEventsHandler {
    private static OptimizedEventsHandler instance;
    private Map<Option, Couple<List<EventName>, Listener>> registered;

    public OptimizedEventsHandler() {
        this.init();
    }

    public void init() {
        this.registered = new HashMap<Option, Couple<List<EventName>, Listener>>();
    }

    public void reload() {
        for (Couple<List<EventName>, Listener> couple : this.registered.values()) {
            if (couple.getElem1() != null) {
                for (EventName eN : (List)couple.getElem1()) {
                    DynamicRegistration.getInstance().unregister(eN, (JavaPlugin)MyFurniture.plugin);
                }
            }
            if (couple.getElem2() == null) continue;
            HandlerList.unregisterAll((Listener)((Listener)couple.getElem2()));
        }
        this.init();
    }

    public void read(SOption option) {
        if (!(option instanceof Option)) {
            return;
        }
        Option o = (Option)option;
        if (!this.registered.containsKey(option)) {
            ArrayList eventsName = new ArrayList();
            Object mainListerner = null;
            switch (o) {
                case PLAYER_BREAK: {
                    mainListerner = new FurnitureBreakListener();
                    break;
                }
                case PLAYER_PLACE: {
                    mainListerner = new FurniturePlaceListener();
                    break;
                }
                case PLAYER_SCROLL_UP_BY_TARGETING: {
                    mainListerner = new PlayerScrollUpByTargetingListener();
                    break;
                }
                case PLAYER_SCROLL_DOWN_BY_TARGETING: {
                    mainListerner = new PlayerScrollDownByTargetingListener();
                }
            }
            if (mainListerner != null) {
                MyFurniture.plugin.getServer().getPluginManager().registerEvents((Listener)mainListerner, (Plugin)MyFurniture.plugin);
                this.registered.put(o, (Couple<List<EventName>, Listener>)new Couple(eventsName, mainListerner));
            }
        }
    }

    public void displayOptimisation() {
        MyFurniture.plugin.getServer().getLogger().info("================ [MyFurniture Check Options] ================");
        MyFurniture.plugin.getServer().getLogger().info("All options available in MyFurniture: ");
        MyFurniture.plugin.getServer().getLogger().info("true: a Furniture has an activator that use it.");
        MyFurniture.plugin.getServer().getLogger().info("false: no Furniture require this event. (better performance)");
        MyFurniture.plugin.getServer().getLogger().info("Use only what you need, more false = better performance");
        MyFurniture.plugin.getServer().getLogger().info("");
        for (Option o : Option.values()) {
            MyFurniture.plugin.getServer().getLogger().info((Object)((Object)o) + " >> " + this.registered.containsKey((Object)o));
        }
        MyFurniture.plugin.getServer().getLogger().info("================ [MyFurniture Check Options] ================");
    }

    public boolean isRegistered(Option option) {
        return this.registered.containsKey((Object)option);
    }

    public static OptimizedEventsHandler getInstance() {
        if (instance == null) {
            instance = new OptimizedEventsHandler();
        }
        return instance;
    }
}

