/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.myfurniture.listeners.mechanics;

import com.ssomar.myfurniture.furniture.Furniture;
import com.ssomar.myfurniture.furniture.creations.CreationAbstract;
import com.ssomar.myfurniture.furniture.placedfurniture.FurniturePlaced;
import com.ssomar.myfurniture.furniture.placedfurniture.FurniturePlacedManager;
import com.ssomar.myfurniture.furniture.placedfurniture.TargetResult;
import com.ssomar.myfurniture.listeners.activators.PlayerAllClickOnListener;
import com.ssomar.myfurniture.listeners.activators.PlayerLeftClickOnListener;
import com.ssomar.score.SsomarDev;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class BreakFurnitureListener
implements Listener {
    private static final Boolean DEBUG = true;
    private static Map<Player, Long> cooldownsPlayerAnimation;

    public BreakFurnitureListener() {
        cooldownsPlayerAnimation = new HashMap<Player, Long>();
    }

    public static void addCooldown(Player player, long time) {
        cooldownsPlayerAnimation.put(player, System.currentTimeMillis() + time);
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onPlayerAnimationEvent(PlayerAnimationEvent e) {
        SsomarDev.testMsg((String)("PlayerAnimationEvent  " + e.getAnimationType()), (boolean)DEBUG);
        Player player = e.getPlayer();
        if (cooldownsPlayerAnimation.containsKey(player) && cooldownsPlayerAnimation.get(player) > System.currentTimeMillis()) {
            SsomarDev.testMsg((String)("PlayerAnimationEvent  CANCEL COOLDOWN" + e.getAnimationType()), (boolean)DEBUG);
            return;
        }
        BreakFurnitureListener.addCooldown(player, 300L);
        Optional<TargetResult> eBPO = FurniturePlacedManager.getInstance().getFurniturePlacedDisplayTargetByPlayer(player);
        if (!eBPO.isPresent()) {
            SsomarDev.testMsg((String)"PlayerInteractEvent NO Furniture targeted", (boolean)DEBUG);
            return;
        }
        TargetResult targetResult = eBPO.get();
        FurniturePlaced furniturePlaced = targetResult.getFurniturePlaced();
        Furniture furniture = furniturePlaced.getFurniture();
        e.setCancelled(true);
        SsomarDev.testMsg((String)("Player HIT the boundingboxId >> " + targetResult.getBoundingBoxId()), (boolean)DEBUG);
        PlayerAllClickOnListener.onInteract(e, furniturePlaced);
        PlayerLeftClickOnListener.onInteract(e, furniturePlaced);
        if (!furniture.checkIfPlayerCanBreakAt(player, furniturePlaced.getLocation(), true)) {
            SsomarDev.testMsg((String)"BlockBreakEvent CANT BREAK", (boolean)DEBUG);
            return;
        }
        ItemStack item1 = player.getInventory().getItemInMainHand();
        if (item1.getType().equals((Object)Material.AIR)) {
            item1 = player.getInventory().getItemInOffHand();
        }
        if (!furniture.getOnlyBreakableWithEI().isValid(item1)) {
            SsomarDev.testMsg((String)"BlockBreakEvent NOT THE GOOD EI", (boolean)DEBUG);
            return;
        }
        CreationAbstract display = furniturePlaced.getCreation();
        if (!display.tryBreak()) {
            e.setCancelled(true);
            SsomarDev.testMsg((String)"BlockBreakEvent TRY TO BREAK CANT BREAK", (boolean)DEBUG);
            return;
        }
        if (furniturePlaced.isRemoved()) {
            return;
        }
        SsomarDev.testMsg((String)"BlockBreakEvent BREAK DISPLAY", (boolean)DEBUG);
        targetResult.getFurniturePlaced().breakFurniture(player, true, (Event)e, FurniturePlaced.BreakMethod.CUSTOM);
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onPlayerInteractEvent(PlayerInteractEvent e) {
        SsomarDev.testMsg((String)"PlayerInteractEvent ", (boolean)DEBUG);
        Player player = e.getPlayer();
        if (player.getGameMode() != GameMode.CREATIVE) {
            return;
        }
        Optional<TargetResult> eBPO = FurniturePlacedManager.getInstance().getFurniturePlacedDisplayTargetByPlayer(player);
        if (!eBPO.isPresent()) {
            return;
        }
        SsomarDev.testMsg((String)"PlayerInteractEvent CANCELLED", (boolean)DEBUG);
        e.setCancelled(true);
    }
}

