/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.myfurniture.utils;

import com.ssomar.myfurniture.utils.Triangle;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class MollerTrumbore {
    private static double EPSILON = 1.0E-7;

    public static boolean rayIntersectsTriangle(Point3d rayOrigin, Vector3d rayVector, Triangle inTriangle, Point3d outIntersectionPoint) {
        Point3d vertex0 = new Point3d((double)inTriangle.p0.x, (double)inTriangle.p0.y, (double)inTriangle.p0.z);
        Point3d vertex1 = new Point3d((double)inTriangle.p1.x, (double)inTriangle.p1.y, (double)inTriangle.p1.z);
        Point3d vertex2 = new Point3d((double)inTriangle.p2.x, (double)inTriangle.p2.y, (double)inTriangle.p2.z);
        Vector3d edge1 = new Vector3d();
        Vector3d edge2 = new Vector3d();
        Vector3d h = new Vector3d();
        Vector3d s = new Vector3d();
        Vector3d q = new Vector3d();
        edge1.sub((Tuple3d)vertex1, (Tuple3d)vertex0);
        edge2.sub((Tuple3d)vertex2, (Tuple3d)vertex0);
        h.cross(rayVector, edge2);
        double a = edge1.dot(h);
        if (a > -EPSILON && a < EPSILON) {
            return false;
        }
        double f = 1.0 / a;
        s.sub((Tuple3d)rayOrigin, (Tuple3d)vertex0);
        double u = f * s.dot(h);
        if (u < 0.0 || u > 1.0) {
            return false;
        }
        q.cross(s, edge1);
        double v = f * rayVector.dot(q);
        if (v < 0.0 || u + v > 1.0) {
            return false;
        }
        double t = f * edge2.dot(q);
        if (t > EPSILON) {
            outIntersectionPoint.set(0.0, 0.0, 0.0);
            outIntersectionPoint.scaleAdd(t, (Tuple3d)rayVector, (Tuple3d)rayOrigin);
            return true;
        }
        return false;
    }
}

