/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.myfurniture.commands;

import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.session.SessionManager;
import com.sk89q.worldedit.session.SessionOwner;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.util.WorldEditRegionConverter;
import com.ssomar.myfurniture.configs.GeneralConfig;
import com.ssomar.myfurniture.furniture.Furniture;
import com.ssomar.myfurniture.furniture.FurnitureManager;
import com.ssomar.myfurniture.furniture.placedfurniture.FurniturePlaced;
import com.ssomar.myfurniture.furniture.placedfurniture.FurniturePlacedManager;
import com.ssomar.score.SCore;
import com.ssomar.score.usedapi.AllWorldManager;
import com.ssomar.score.utils.messages.SendMessage;
import com.ssomar.score.utils.place.OverrideMode;
import java.util.Iterator;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class PlaceCommand {
    public static void sendPlace(Player player, String[] args) {
        if (!SCore.hasWorldEdit) {
            SendMessage.sendMessageNoPlch((Player)player, (String)"&4&l[MyFurniture] &cERROR &6WorldEdit plugin&c is required for the command &6&o/eb we-place {MyFurnitureID}");
            return;
        }
        if (args.length == 1) {
            Region region;
            Optional oOpt = FurnitureManager.getInstance().getLoadedObjectWithID(args[0]);
            if (!oOpt.isPresent()) {
                SendMessage.sendMessageNoPlch((Player)player, (String)"&4&l[MyFurniture] &cERROR Please select a valid MyFurniture. &7&o/eb we-place {MyFurnitureID}");
                return;
            }
            Furniture eB = (Furniture)((Object)oOpt.get());
            BukkitPlayer actor = BukkitAdapter.adapt((Player)player);
            SessionManager manager = WorldEdit.getInstance().getSessionManager();
            LocalSession localSession = manager.get((SessionOwner)actor);
            World selectionWorld = localSession.getSelectionWorld();
            try {
                if (selectionWorld == null) {
                    throw new IncompleteRegionException();
                }
                region = localSession.getSelection(selectionWorld);
            }
            catch (IncompleteRegionException ex) {
                SendMessage.sendMessageNoPlch((Player)player, (String)"&4&l[MyFurniture] &cERROR Please make a region selection first then &6&o/eb we-place {MyFurnitureID}");
                return;
            }
            int max = GeneralConfig.getInstance().getIntSetting(GeneralConfig.Setting.maxFurniturePlacedUsingCommand.name(), 500);
            int cpt = 0;
            for (BlockVector3 point : region) {
                if (cpt >= max) {
                    SendMessage.sendMessageNoPlch((Player)player, (String)("&4&l[MyFurniture] &cERROR You can't place more than &6" + max + " &cMyFurniture with this command, or modify the setting maxFurniturePlacedUsingCommand in your config.yml (at your own risk)"));
                    break;
                }
                Location bLoc = new Location(BukkitAdapter.adapt((World)region.getWorld()), (double)point.getBlockX(), (double)point.getBlockY(), (double)point.getBlockZ());
                Block b = bLoc.getBlock();
                b.setType(Material.AIR);
                eB.place(bLoc, OverrideMode.REMOVE_EXISTING, null, null);
                ++cpt;
            }
        } else {
            SendMessage.sendMessageNoPlch((Player)player, (String)"&4&l[MyFurniture] &cERROR not enough arguments &6&o/eb we-place {MyFurnitureID}");
        }
    }

    public static void fillRegion(@Nullable Player player, String[] args) {
        if (!SCore.hasWorldEdit || !SCore.hasWorldGuard) {
            SendMessage.sendMessageNoPlch((Player)player, (String)"&4&l[MyFurniture] &cERROR &6WorldEdit & Worldguard plugins&c are required for the command &6&o/eb wg-fill-region {world} {region} stone:50,MyEB:50");
            return;
        }
        if (args.length >= 3) {
            Optional bukkitWorldOpt = AllWorldManager.getWorld((String)args[0]);
            if (!bukkitWorldOpt.isPresent()) {
                SendMessage.sendMessageNoPlch((Player)player, (String)"&4&l[MyFurniture] &cERROR Please select a valid world. &7&o/eb wg-fill-region {world} {region} stone:50,MyEB:50");
                return;
            }
            org.bukkit.World bukkitWorld = (org.bukkit.World)bukkitWorldOpt.get();
            WorldGuard worldGuard = WorldGuard.getInstance();
            World world = BukkitAdapter.adapt((org.bukkit.World)bukkitWorld);
            ProtectedRegion region = worldGuard.getPlatform().getRegionContainer().get(world).getRegion(args[1]);
            Region weRegion = WorldEditRegionConverter.convertToRegion((ProtectedRegion)region);
            Iterator iterator = weRegion.iterator();
            TreeMap<Integer, Object> map = new TreeMap<Integer, Object>();
            String[] split = args[2].split(",");
            int total = 0;
            for (String s : split) {
                String[] split2 = s.split(":");
                if (split2.length == 2) {
                    try {
                        int i = Integer.parseInt(split2[1]);
                        total += i;
                        String material = split2[0];
                        if (Material.matchMaterial((String)material) != null) {
                            map.put(total, Material.matchMaterial((String)material.toUpperCase()));
                            continue;
                        }
                        if (FurnitureManager.getInstance().getLoadedObjectWithID(material).isPresent()) {
                            map.put(total, FurnitureManager.getInstance().getLoadedObjectWithID(material).get());
                            continue;
                        }
                        SendMessage.sendMessageNoPlch((Player)player, (String)"&4&l[MyFurniture] &cERROR Please enter a valid material or MyFurnitureID &6&o/eb wg-fill-region {world} {region} stone:50,MyEB:50");
                        return;
                    }
                    catch (Exception e) {
                        SendMessage.sendMessageNoPlch((Player)player, (String)"&4&l[MyFurniture] &cERROR Please enter a valid number for the percentage &6&o/eb wg-fill-region {world} {region} stone:50,MyEB:50");
                        return;
                    }
                }
                SendMessage.sendMessageNoPlch((Player)player, (String)"&4&l[MyFurniture] &cERROR Please enter a valid percentage &6&o/eb wg-fill-region {world} {region} stone:50,MyEB:50");
                return;
            }
            if (total != 100) {
                SendMessage.sendMessageNoPlch((Player)player, (String)"&4&l[MyFurniture] &cERROR Please enter a total for the percentages of 100  &6&o/eb wg-fill-region {world} {region} stone:50,MyEB:50");
                return;
            }
            int max = GeneralConfig.getInstance().getIntSetting(GeneralConfig.Setting.maxFurniturePlacedUsingCommand.name(), 500);
            int cpt = 0;
            while (iterator.hasNext()) {
                if (cpt >= max) {
                    SendMessage.sendMessageNoPlch((Player)player, (String)("&4&l[MyFurniture] &cERROR You can't fill more than &6" + max + " &cblocks with this command, or modify the setting maxFurniturePlacedUsingCommand in your config.yml (at your own risk)"));
                    break;
                }
                BlockVector3 point = (BlockVector3)iterator.next();
                Location bLoc = new Location(bukkitWorld, (double)point.getBlockX(), (double)point.getBlockY(), (double)point.getBlockZ());
                Block b = bLoc.getBlock();
                int random = ThreadLocalRandom.current().nextInt(1, 101);
                for (Integer i : map.keySet()) {
                    if (random > i) continue;
                    Object o = map.get(i);
                    if (o instanceof Material) {
                        b.setType((Material)o);
                        break;
                    }
                    if (!(o instanceof Furniture)) continue;
                    Furniture eB = (Furniture)((Object)o);
                    b.setType(Material.AIR);
                    eB.place(bLoc, OverrideMode.REMOVE_EXISTING, null, null);
                    break;
                }
                ++cpt;
            }
        } else {
            SendMessage.sendMessageNoPlch((Player)player, (String)"&4&l[MyFurniture] &cERROR not enough arguments &6&o/eb wg-fill-region {world} {region} stone:50,MyEB:50");
        }
    }

    public static void sendReplace(Player player, String[] args) {
        if (!SCore.hasWorldEdit) {
            SendMessage.sendMessageNoPlch((Player)player, (String)"&4&l[MyFurniture] &cERROR &6WorldEdit plugin&c is required for the command &6&o/eb we-replace {material or MyFurnitureID} {MyFurnitureID}");
            return;
        }
        if (args.length == 2) {
            Region region;
            Optional<Object> oMat = Optional.empty();
            Optional oEB = Optional.empty();
            try {
                oMat = Optional.ofNullable(Material.valueOf((String)args[0].toUpperCase()));
            }
            catch (Exception e) {
                try {
                    oEB = FurnitureManager.getInstance().getLoadedObjectWithID(args[0]);
                }
                catch (Exception e1) {
                    SendMessage.sendMessageNoPlch((Player)player, (String)"&4&l[MyFurniture] &cERROR Please select a valid material or MyFurniture. &7&o/eb we-replace {material or MyFurnitureID} {MyFurnitureID}");
                    return;
                }
            }
            Optional oOpt = FurnitureManager.getInstance().getLoadedObjectWithID(args[1]);
            if (!oOpt.isPresent()) {
                SendMessage.sendMessageNoPlch((Player)player, (String)"&4&l[MyFurniture] &cERROR Please select a valid MyFurniture. &7&o/eb we-replace {material or MyFurnitureID} {MyFurnitureID}");
                return;
            }
            Furniture eB = (Furniture)((Object)oOpt.get());
            BukkitPlayer actor = BukkitAdapter.adapt((Player)player);
            SessionManager manager = WorldEdit.getInstance().getSessionManager();
            LocalSession localSession = manager.get((SessionOwner)actor);
            World selectionWorld = localSession.getSelectionWorld();
            try {
                if (selectionWorld == null) {
                    throw new IncompleteRegionException();
                }
                region = localSession.getSelection(selectionWorld);
            }
            catch (IncompleteRegionException ex) {
                SendMessage.sendMessageNoPlch((Player)player, (String)"&4&l[MyFurniture] &cERROR Please make a region selection first then &6&o/eb we-replace {material or MyFurnitureID} {MyFurnitureID}");
                return;
            }
            int cpt = 0;
            int max = GeneralConfig.getInstance().getIntSetting(GeneralConfig.Setting.maxFurniturePlacedUsingCommand.name(), 500);
            for (BlockVector3 point : region) {
                Optional<FurniturePlaced> eBP;
                if (cpt >= max) {
                    SendMessage.sendMessageNoPlch((Player)player, (String)("&4&l[MyFurniture] &cERROR You can't replace more than &6" + max + " &cMyFurniture with this command, or modify the setting maxFurniturePlacedUsingCommand in your config.yml (at your own risk)"));
                    break;
                }
                Location bLoc = new Location(BukkitAdapter.adapt((World)region.getWorld()), (double)point.getBlockX(), (double)point.getBlockY(), (double)point.getBlockZ());
                Block b = bLoc.getBlock();
                if (oMat.isPresent()) {
                    if (!b.getType().equals(oMat.get())) continue;
                    b.setType(Material.AIR);
                    eB.place(bLoc, OverrideMode.REMOVE_EXISTING, null, null);
                    ++cpt;
                    continue;
                }
                if (!oEB.isPresent() || !(eBP = FurniturePlacedManager.getInstance().getFurniturePlaced(b)).isPresent() || !eBP.get().getFurnitureID().equals(((Furniture)((Object)oEB.get())).getId())) continue;
                b.setType(Material.AIR);
                eB.place(bLoc, OverrideMode.REMOVE_EXISTING, null, null);
                ++cpt;
            }
            SendMessage.sendMessageNoPlch((Player)player, (String)("&2&l[MyFurniture] &aCommand executed ! &e" + cpt + " &afurniture replaced !"));
        } else {
            SendMessage.sendMessageNoPlch((Player)player, (String)"&4&l[MyFurniture] &cERROR not enough arguments &6&o/mf we-replace {material or MyFurnitureID} {MyFurnitureID}");
        }
    }
}

