/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.myfurniture.commands;

import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.session.SessionManager;
import com.sk89q.worldedit.session.SessionOwner;
import com.sk89q.worldedit.world.World;
import com.ssomar.myfurniture.furniture.placedfurniture.FurniturePlaced;
import com.ssomar.myfurniture.furniture.placedfurniture.FurniturePlacedManager;
import com.ssomar.myfurniture.furniture.placedfurniture.LocationConverter;
import com.ssomar.score.SCore;
import com.ssomar.score.utils.messages.SendMessage;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;

public class RemoveCommand {
    public static void sendRemove(Player player, String[] args) {
        Region region;
        boolean replaceTheEBbyAir = false;
        if (!SCore.hasWorldEdit) {
            SendMessage.sendMessageNoPlch((Player)player, (String)"&4&l[ExecutableBlocks] &cERROR &6WorldEdit plugin&c is required for the command &6&o/eb we-remove [replaceTheEBbyAir]]");
            return;
        }
        if (args.length == 1) {
            replaceTheEBbyAir = Boolean.parseBoolean(args[0]);
        }
        BukkitPlayer actor = BukkitAdapter.adapt((Player)player);
        SessionManager manager = WorldEdit.getInstance().getSessionManager();
        LocalSession localSession = manager.get((SessionOwner)actor);
        World selectionWorld = localSession.getSelectionWorld();
        try {
            if (selectionWorld == null) {
                throw new IncompleteRegionException();
            }
            region = localSession.getSelection(selectionWorld);
        }
        catch (IncompleteRegionException ex) {
            SendMessage.sendMessageNoPlch((Player)player, (String)"&4&l[ExecutableBlocks] &cERROR Please make a region selection first then &6&o/eb we-remove [replaceTheEBbyAir]");
            return;
        }
        for (BlockVector3 point : region) {
            Location bLoc = new Location(BukkitAdapter.adapt((World)region.getWorld()), (double)point.getBlockX(), (double)point.getBlockY(), (double)point.getBlockZ());
            bLoc = LocationConverter.convert(bLoc, false, true);
            Optional<FurniturePlaced> eBPOpt = FurniturePlacedManager.getInstance().getFurniturePlaced(bLoc);
            if (!eBPOpt.isPresent()) continue;
            FurniturePlaced eBP = eBPOpt.get();
            FurniturePlacedManager.getInstance().removeFurniturePlaced(eBP);
            if (!replaceTheEBbyAir) continue;
            bLoc.getBlock().setType(Material.AIR);
        }
    }
}

