/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.myfurniture.commands;

import com.ssomar.myfurniture.furniture.placedfurniture.FurniturePlaced;
import com.ssomar.myfurniture.furniture.placedfurniture.FurniturePlacedManager;
import com.ssomar.score.usedapi.AllWorldManager;
import com.ssomar.score.utils.emums.VariableUpdateType;
import com.ssomar.score.utils.logging.Utils;
import com.ssomar.score.utils.messages.SendMessage;
import com.ssomar.score.utils.numbers.NTools;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class VariableModificationCommand {
    private String command;
    private VariableUpdateType type;
    private String variableName;
    private String value;
    private Player player;
    private FurniturePlaced ebPlaced;
    private int usageModification;
    private boolean valid;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public VariableModificationCommand(String command, String[] args, @Nullable Player player) {
        this.command = command;
        this.player = player;
        String commandTemplate = "eb modification {set/modification} {usage/variable} ....";
        try {
            String typeStr = args[0];
            if (typeStr.equalsIgnoreCase("set")) {
                this.type = VariableUpdateType.SET;
            } else {
                if (!typeStr.equalsIgnoreCase("modification")) {
                    this.sendError(command, "&a5[MyFurniture] &cThe update type is not valid (set or modification)! Try again. &8Command: &7" + commandTemplate);
                    this.valid = false;
                    return;
                }
                this.type = VariableUpdateType.MODIFICATION;
            }
            String what = args[1];
            int valueIndex = 0;
            int variableIndex = 0;
            if (what.equalsIgnoreCase("variable")) {
                variableIndex = 6;
                valueIndex = 7;
            } else {
                if (!what.equalsIgnoreCase("usage")) {
                    this.sendError(command, "&a5[MyFurniture] &cWhat you want update is not specified correctly (variable or usage)! Try again. &8Command: &7" + commandTemplate);
                    this.valid = false;
                    return;
                }
                this.variableName = "usage";
                valueIndex = 6;
            }
            if (what.equalsIgnoreCase("usage")) {
                commandTemplate = "/ei modification " + typeStr + " usage {world} {x} {y} {z} {value}";
            } else if (what.equalsIgnoreCase("variable")) {
                commandTemplate = "/ei modification " + typeStr + " variable {world} {x} {y} {z} {variableName} {value}";
            }
            String worldStr = args[2];
            String xStr = args[3];
            String yStr = args[4];
            String zStr = args[5];
            Optional worldOpt = AllWorldManager.getWorld((String)worldStr);
            if (!worldOpt.isPresent()) {
                this.sendError(command, "&a5[MyFurniture] &cThe world " + worldStr + " is not a valid world ! Try again. &8Command: &7" + commandTemplate);
                this.valid = false;
                return;
            }
            if (!NTools.isNumber((String)xStr)) {
                this.sendError(command, "&a5[MyFurniture] &cThe x " + xStr + " is not a valid number ! Try again. &8Command: &7" + commandTemplate);
                this.valid = false;
                return;
            }
            if (!NTools.isNumber((String)yStr)) {
                this.sendError(command, "&a5[MyFurniture] &cThe y " + yStr + " is not a valid number ! Try again. &8Command: &7" + commandTemplate);
                this.valid = false;
                return;
            }
            if (!NTools.isNumber((String)zStr)) {
                this.sendError(command, "&a5[MyFurniture] &cThe z " + zStr + " is not a valid number ! Try again. &8Command: &7" + commandTemplate);
                this.valid = false;
                return;
            }
            Location loc = new Location((World)worldOpt.get(), Double.parseDouble(xStr), Double.parseDouble(yStr), Double.parseDouble(zStr));
            if (what.equalsIgnoreCase("variable")) {
                this.variableName = args[variableIndex];
            }
            if (what.equalsIgnoreCase("usage")) {
                String usageStr = args[valueIndex];
                if (!NTools.isNumber((String)usageStr)) {
                    this.sendError(command, "&a5[MyFurniture] &cThe usage " + usageStr + " is not a number ! Try again. &8Command: &7" + commandTemplate);
                    this.valid = false;
                    return;
                }
                this.usageModification = Integer.parseInt(usageStr);
            } else {
                if (args.length <= valueIndex) {
                    this.sendError(command, "&a5[MyFurniture] &cThe value is not specified ! Try again. &8Command: &7" + commandTemplate);
                    this.valid = false;
                    return;
                }
                this.value = args[valueIndex];
                for (int i = valueIndex + 1; i < args.length; ++i) {
                    this.value = this.value + " " + args[i];
                }
            }
            Optional<FurniturePlaced> ebPlacedOpt = FurniturePlacedManager.getInstance().getFurniturePlaced(loc.getBlock());
            if (!ebPlacedOpt.isPresent()) {
                this.sendError(command, "&a5[MyFurniture] &cThe block at " + loc.getBlockX() + " " + loc.getBlockY() + " " + loc.getBlockZ() + " is not an executable block ! Try again. &8Command: &7" + commandTemplate);
                this.valid = false;
                return;
            }
            this.ebPlaced = ebPlacedOpt.get();
        }
        catch (Exception e) {
            this.sendError(command, "&a5[MyFurniture] &cAn error occurred while executing the command ! (Probably insufficient arguments) Try again. &8Command: &7" + commandTemplate);
            this.valid = false;
            return;
        }
        this.valid = true;
    }

    public void sendError(String command, String message) {
        if (command.equalsIgnoreCase("modification") && this.player != null) {
            SendMessage.sendMessageNoPlch((Player)this.player, (String)message);
        } else {
            Bukkit.getServer().getLogger().severe(StringConverter.decoloredString((String)message));
        }
    }

    public void sendInfo(String command, String message) {
        if (command.equalsIgnoreCase("modification") && this.player != null) {
            SendMessage.sendMessageNoPlch((Player)this.player, (String)message);
        } else {
            Utils.sendConsoleMsg((String)message);
        }
    }

    public void run() {
        if (!this.valid) {
            return;
        }
        if (this.variableName.equals("usage")) {
            switch (this.type) {
                case SET: {
                    break;
                }
                case MODIFICATION: {
                    this.usageModification += this.ebPlaced.getUsage();
                }
            }
            this.ebPlaced.setUsage(this.usageModification);
            this.ebPlaced.updateTitle();
            this.sendInfo(this.command, "&a5[MyFurniture]&aThe usage of the block at &e" + this.ebPlaced.getLocation().getBlockX() + " " + this.ebPlaced.getLocation().getBlockY() + " " + this.ebPlaced.getLocation().getBlockZ() + " &ahas been updated to &e" + this.usageModification + " &a!");
        } else {
            String newValue = this.ebPlaced.updateVariable(this.variableName, this.value, this.type);
            this.ebPlaced.updateTitle();
            this.sendInfo(this.command, "&a5[MyFurniture] &aThe variable &e" + this.variableName + " &aof the block at &e" + this.ebPlaced.getLocation().getBlockX() + " " + this.ebPlaced.getLocation().getBlockY() + " " + this.ebPlaced.getLocation().getBlockZ() + "&a has been updated to &e" + newValue + "&a !");
        }
    }
}

