/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.myfurniture.features.display.boundingboxzones.group;

import com.ssomar.myfurniture.features.display.boundingboxzones.boundingboxzone.BoundingBoxZoneFeature;
import com.ssomar.score.features.FeatureAbstract;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeaturesGroup;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.obfuscation.KeepMethod;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class BoundingBoxZoneGroupFeature
extends FeatureAbstract<BoundingBoxZoneGroupFeature, BoundingBoxZoneGroupFeature>
implements FeaturesGroup<BoundingBoxZoneFeature>,
FeatureParentInterface<BoundingBoxZoneGroupFeature, BoundingBoxZoneGroupFeature> {
    private Map<String, BoundingBoxZoneFeature> boundingBoxZones;
    private boolean notSaveIfNoValue;

    public BoundingBoxZoneGroupFeature(FeatureParentInterface parent, boolean notSaveIfNoValue) {
        super(parent, (FeatureSettingsInterface)FeatureSettingsSCore.boundingBoxZones);
        this.notSaveIfNoValue = notSaveIfNoValue;
        this.reset();
    }

    @KeepMethod
    public void reset() {
        this.boundingBoxZones = new HashMap<String, BoundingBoxZoneFeature>();
    }

    @KeepMethod
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection enchantmentsSection = config.getConfigurationSection(this.getName());
            for (String enchantmentID : enchantmentsSection.getKeys(false)) {
                BoundingBoxZoneFeature enchantment = new BoundingBoxZoneFeature(this, enchantmentID);
                List<String> subErrors = enchantment.load(plugin, enchantmentsSection, isPremiumLoading);
                if (subErrors.size() > 0) {
                    error.addAll(subErrors);
                    continue;
                }
                this.boundingBoxZones.put(enchantmentID, enchantment);
            }
        }
        return error;
    }

    @KeepMethod
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        if (this.notSaveIfNoValue && this.boundingBoxZones.size() == 0) {
            return;
        }
        ConfigurationSection enchantmentsSection = config.createSection(this.getName());
        for (String enchantmentID : this.boundingBoxZones.keySet()) {
            this.boundingBoxZones.get(enchantmentID).save(enchantmentsSection);
        }
    }

    @KeepMethod
    public BoundingBoxZoneGroupFeature getValue() {
        return this;
    }

    @KeepMethod
    public BoundingBoxZoneGroupFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = "&7&oEnchantment(s) added: &e" + this.boundingBoxZones.size();
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @KeepMethod
    public void updateItemParentEditor(GUI gui) {
    }

    @KeepMethod
    public BoundingBoxZoneFeature getTheChildFeatureClickedParentEditor(String featureClicked) {
        for (BoundingBoxZoneFeature x : this.boundingBoxZones.values()) {
            if (!x.isTheFeatureClickedParentEditor(featureClicked)) continue;
            return x;
        }
        return null;
    }

    @KeepMethod
    public BoundingBoxZoneGroupFeature clone(FeatureParentInterface newParent) {
        BoundingBoxZoneGroupFeature eF = new BoundingBoxZoneGroupFeature(newParent, this.isNotSaveIfNoValue());
        HashMap<String, BoundingBoxZoneFeature> newEnchantments = new HashMap<String, BoundingBoxZoneFeature>();
        for (String x : this.boundingBoxZones.keySet()) {
            newEnchantments.put(x, this.boundingBoxZones.get(x).clone(eF));
        }
        eF.setBoundingBoxZones(newEnchantments);
        return eF;
    }

    @KeepMethod
    public List<FeatureInterface> getFeatures() {
        return new ArrayList<BoundingBoxZoneFeature>(this.boundingBoxZones.values());
    }

    public FeatureInterface getFeature(FeatureSettingsInterface featureSettingsInterface) {
        return null;
    }

    public FeatureInterface getFeatureWithName(String s) {
        return null;
    }

    @KeepMethod
    public String getParentInfo() {
        if (this.getParent() == this) {
            return "";
        }
        return this.getParent().getParentInfo();
    }

    @KeepMethod
    public ConfigurationSection getConfigurationSection() {
        ConfigurationSection section = this.getParent().getConfigurationSection();
        if (section.isConfigurationSection(this.getName())) {
            return section.getConfigurationSection(this.getName());
        }
        return section.createSection(this.getName());
    }

    @KeepMethod
    public File getFile() {
        return this.getParent().getFile();
    }

    @KeepMethod
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof BoundingBoxZoneGroupFeature)) continue;
            BoundingBoxZoneGroupFeature eF = (BoundingBoxZoneGroupFeature)feature;
            eF.setBoundingBoxZones(this.getBoundingBoxZones());
            break;
        }
    }

    @KeepMethod
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @KeepMethod
    public void openEditor(@NotNull Player player) {
    }

    @KeepMethod
    public void createNewFeature(@NotNull Player editor) {
        String baseId = "enchantment";
        for (int i = 0; i < 1000; ++i) {
            String id = baseId + i;
            if (this.boundingBoxZones.containsKey(id)) continue;
            BoundingBoxZoneFeature eF = new BoundingBoxZoneFeature(this, id);
            this.boundingBoxZones.put(id, eF);
            eF.openEditor(editor);
            break;
        }
    }

    @KeepMethod
    public void deleteFeature(@NotNull Player editor, BoundingBoxZoneFeature feature) {
        this.boundingBoxZones.remove(feature.getId());
    }

    public Map<String, BoundingBoxZoneFeature> getBoundingBoxZones() {
        return this.boundingBoxZones;
    }

    public boolean isNotSaveIfNoValue() {
        return this.notSaveIfNoValue;
    }

    public void setBoundingBoxZones(Map<String, BoundingBoxZoneFeature> boundingBoxZones) {
        this.boundingBoxZones = boundingBoxZones;
    }

    public void setNotSaveIfNoValue(boolean notSaveIfNoValue) {
        this.notSaveIfNoValue = notSaveIfNoValue;
    }
}

