/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.myfurniture.furniture;

import com.ssomar.myfurniture.MyFurniture;
import com.ssomar.myfurniture.api.events.FurniturePlaceEvent;
import com.ssomar.myfurniture.configs.GeneralConfig;
import com.ssomar.myfurniture.configs.messages.Message;
import com.ssomar.myfurniture.editor.FurnituresEditor;
import com.ssomar.myfurniture.features.display.DisplayFeatures;
import com.ssomar.myfurniture.furniture.FurnitureLoader;
import com.ssomar.myfurniture.furniture.FurnitureObject;
import com.ssomar.myfurniture.furniture.activators.ActivatorMFFeature;
import com.ssomar.myfurniture.furniture.creations.Creations;
import com.ssomar.myfurniture.furniture.editor.FurnitureEditor;
import com.ssomar.myfurniture.furniture.editor.FurnitureEditorManager;
import com.ssomar.myfurniture.furniture.placedfurniture.FurniturePlaced;
import com.ssomar.myfurniture.furniture.placedfurniture.PlayerLimit;
import com.ssomar.score.api.executableitems.ExecutableItemsAPI;
import com.ssomar.score.api.executableitems.config.ExecutableItemInterface;
import com.ssomar.score.api.myfurniture.config.FurnitureInterface;
import com.ssomar.score.configs.messages.MessageInterface;
import com.ssomar.score.configs.messages.MessageMain;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.custom.activators.activator.SActivator;
import com.ssomar.score.features.custom.activators.group.ActivatorsFeature;
import com.ssomar.score.features.custom.blocktitle.BlockTitleFeatures;
import com.ssomar.score.features.custom.sit.SitFeatures;
import com.ssomar.score.features.custom.storage.StorageFeatures;
import com.ssomar.score.features.custom.variables.base.group.VariablesGroupFeature;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.features.types.DoubleFeature;
import com.ssomar.score.features.types.DropTypeFeature;
import com.ssomar.score.features.types.ExecutableItemFeature;
import com.ssomar.score.features.types.UncoloredStringFeature;
import com.ssomar.score.features.types.list.ListExecutableItemsFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.sobject.InternalData;
import com.ssomar.score.sobject.SObject;
import com.ssomar.score.sobject.SObjectBuildable;
import com.ssomar.score.sobject.SObjectWithFileEditable;
import com.ssomar.score.sobject.SObjectWithFileLoader;
import com.ssomar.score.sobject.menu.NewSObjectsManagerEditor;
import com.ssomar.score.sobject.menu.SObjectsEditorAbstract;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.usedapi.Dependency;
import com.ssomar.score.utils.DropType;
import com.ssomar.score.utils.itemwriter.ItemKeyWriterReader;
import com.ssomar.score.utils.messages.SendMessage;
import com.ssomar.score.utils.obfuscation.KeepClass;
import com.ssomar.score.utils.obfuscation.KeepMethod;
import com.ssomar.score.utils.place.OverrideMode;
import com.ssomar.score.utils.safebreak.SafeBreak;
import com.ssomar.score.utils.safeplace.SafePlace;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KeepClass
public class Furniture
extends SObjectWithFileEditable<Furniture, FurnitureEditor, FurnitureEditorManager>
implements FurnitureInterface {
    private ActivatorsFeature activatorsFeature;
    private BlockTitleFeatures title;
    private DoubleFeature interactionRange;
    private ListExecutableItemsFeature onlyBreakableWithEI;
    private BooleanFeature dropBlockIfItIsBroken;
    private DropTypeFeature dropType;
    private BooleanFeature resetInternalDatasWhenBroken;
    private DisplayFeatures displayFeatures;
    private ItemKeyWriterReader itemKeyWriterReader = ItemKeyWriterReader.init();
    private ExecutableItemFeature ei;
    private SitFeatures sitFeatures;
    private StorageFeatures storageFeatures;

    protected Furniture(FeatureParentInterface parent, String id, String path) {
        super((SPlugin)MyFurniture.plugin, id, parent, (FeatureSettingsInterface)FeatureSettingsSCore.FURNITURE, path, (SObjectWithFileLoader)FurnitureLoader.getInstance());
        this.reset();
    }

    public Furniture(String id, String path) {
        super((SPlugin)MyFurniture.plugin, id, (FeatureSettingsInterface)FeatureSettingsSCore.FURNITURE, path, (SObjectWithFileLoader)FurnitureLoader.getInstance());
        this.reset();
    }

    @KeepMethod
    public boolean isPremium() {
        return !MyFurniture.plugin.isLotOfWork();
    }

    @KeepMethod
    public ItemStack getIconItem() {
        return this.buildItem(1, Optional.empty());
    }

    @KeepMethod
    public List<String> getDescription() {
        ArrayList<String> description = new ArrayList<String>();
        description.add("\u00a77ID: \u00a7f" + this.getId());
        description.add("\u00a77Path: \u00a7f" + this.getPath());
        description.add("\u00a77Activators: ");
        for (SActivator activator : this.activatorsFeature.getActivators().values()) {
            description.add("\u00a77- " + activator.getId());
        }
        return description;
    }

    @KeepMethod
    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> features = new ArrayList<FeatureInterface>();
        features.add((FeatureInterface)this.displayFeatures);
        features.add((FeatureInterface)this.title);
        features.add((FeatureInterface)this.interactionRange);
        features.add((FeatureInterface)this.onlyBreakableWithEI);
        features.add((FeatureInterface)this.dropBlockIfItIsBroken);
        features.add((FeatureInterface)this.dropType);
        features.add((FeatureInterface)this.resetInternalDatasWhenBroken);
        features.add((FeatureInterface)this.activatorsFeature);
        features.add((FeatureInterface)this.ei);
        features.add((FeatureInterface)this.sitFeatures);
        features.add((FeatureInterface)this.storageFeatures);
        return features;
    }

    @KeepMethod
    public String getParentInfo() {
        return "(Furniture: " + this.getId() + ")";
    }

    @KeepMethod
    public void reload() {
        if (this.getParent() instanceof Furniture) {
            Furniture item = (Furniture)this.getParent();
            item.setActivatorsFeature(this.activatorsFeature);
            item.setTitle(this.title);
            item.setInteractionRange(this.interactionRange);
            item.setOnlyBreakableWithEI(this.onlyBreakableWithEI);
            item.setDropBlockIfItIsBroken(this.dropBlockIfItIsBroken);
            item.setDropType(this.dropType);
            item.setResetInternalDatasWhenBroken(this.resetInternalDatasWhenBroken);
            item.setDisplayFeatures(this.displayFeatures);
            item.setEi(this.ei);
            item.setSitFeatures(this.sitFeatures);
            item.setStorageFeatures(this.storageFeatures);
        }
    }

    @KeepMethod
    public Furniture clone(FeatureParentInterface newParent) {
        Furniture item = new Furniture((FeatureParentInterface)this, this.getId(), this.getPath());
        item.setActivatorsFeature(this.activatorsFeature.clone((FeatureParentInterface)item));
        item.setTitle(this.title.clone((FeatureParentInterface)item));
        item.setInteractionRange(this.interactionRange.clone((FeatureParentInterface)item));
        item.setOnlyBreakableWithEI(this.onlyBreakableWithEI.clone((FeatureParentInterface)item));
        item.setDropBlockIfItIsBroken(this.dropBlockIfItIsBroken.clone((FeatureParentInterface)item));
        item.setDropType(this.dropType.clone((FeatureParentInterface)item));
        item.setResetInternalDatasWhenBroken(this.resetInternalDatasWhenBroken.clone((FeatureParentInterface)item));
        item.setDisplayFeatures(this.displayFeatures.clone((FeatureParentInterface)item));
        item.setEi(this.ei.clone((FeatureParentInterface)item));
        item.setSitFeatures(this.sitFeatures.clone((FeatureParentInterface)item));
        item.setStorageFeatures(this.storageFeatures.clone((FeatureParentInterface)item));
        return item;
    }

    @KeepMethod
    public void openEditor(@NotNull Player player) {
        FurnitureEditorManager.getInstance().startEditing(player, (FeatureParentInterface)this);
    }

    @KeepMethod
    public void openBackEditor(@NotNull Player player) {
        NewSObjectsManagerEditor.getInstance().startEditing(player, (SObjectsEditorAbstract)new FurnituresEditor());
    }

    @KeepMethod
    public List<String> load(SPlugin sPlugin, ConfigurationSection configurationSection, boolean b) {
        ArrayList<String> errors = new ArrayList<String>();
        errors.addAll(this.displayFeatures.load(sPlugin, configurationSection, b));
        errors.addAll(this.title.load(sPlugin, configurationSection, b));
        errors.addAll(this.interactionRange.load(sPlugin, configurationSection, b));
        errors.addAll(this.onlyBreakableWithEI.load(sPlugin, configurationSection, b));
        errors.addAll(this.dropBlockIfItIsBroken.load(sPlugin, configurationSection, b));
        errors.addAll(this.dropType.load(sPlugin, configurationSection, b));
        errors.addAll(this.resetInternalDatasWhenBroken.load(sPlugin, configurationSection, b));
        List errorsEiFeature = this.ei.load(sPlugin, configurationSection, b);
        if (!errorsEiFeature.isEmpty()) {
            errors.addAll(errorsEiFeature);
            if (Dependency.EXECUTABLE_ITEMS.isEnabled()) {
                ExecutableItemInterface ei = ExecutableItemsAPI.registerNewExecutableItemObject((ItemStack)this.buildItem(1, Optional.empty(), true), (String)this.getId(), (String)"MyFurniture/");
                ei.setUsage(-1);
                this.getEi().setValue(Optional.of(this.getId()));
                errors.add("&6Auto-fix, MyFurniture generated the ExecutableItem: &e" + this.getId() + " &6automatically.");
            }
        }
        errors.addAll(this.activatorsFeature.load(sPlugin, configurationSection, b));
        errors.addAll(this.sitFeatures.load(sPlugin, configurationSection, b));
        errors.addAll(this.storageFeatures.load(sPlugin, configurationSection, b));
        return errors;
    }

    @KeepMethod
    public void save(ConfigurationSection configurationSection) {
        for (FeatureInterface feature : this.getFeatures()) {
            feature.save(configurationSection);
        }
        configurationSection.set("config_3", (Object)true);
        configurationSection.set("config_update", (Object)(!MyFurniture.plugin.isLotOfWork() ? 1 : 0));
    }

    @KeepMethod
    public Furniture getValue() {
        return this;
    }

    @KeepMethod
    public Furniture initItemParentEditor(GUI gui, int i) {
        return null;
    }

    @KeepMethod
    public void updateItemParentEditor(GUI gui) {
    }

    @KeepMethod
    public void reset() {
        this.activatorsFeature = new ActivatorsFeature((FeatureParentInterface)this, (SActivator)new ActivatorMFFeature(null, "null"));
        this.title = new BlockTitleFeatures((FeatureParentInterface)this);
        this.interactionRange = new DoubleFeature((FeatureParentInterface)this, Optional.of(6.0), (FeatureSettingsInterface)FeatureSettingsSCore.interactionRange);
        this.onlyBreakableWithEI = new ListExecutableItemsFeature((FeatureParentInterface)this, new ArrayList(), (FeatureSettingsInterface)FeatureSettingsSCore.onlyBreakableWithEI);
        this.dropBlockIfItIsBroken = new BooleanFeature((FeatureParentInterface)this, Boolean.valueOf(true), (FeatureSettingsInterface)FeatureSettingsSCore.dropBlockIfItIsBroken);
        this.dropType = new DropTypeFeature((FeatureParentInterface)this, Optional.of(DropType.IN_THE_INVENTORY), (FeatureSettingsInterface)FeatureSettingsSCore.dropType);
        this.resetInternalDatasWhenBroken = new BooleanFeature((FeatureParentInterface)this, Boolean.valueOf(false), (FeatureSettingsInterface)FeatureSettingsSCore.resetInternalDatasWhenBroken);
        this.displayFeatures = new DisplayFeatures((FeatureParentInterface)this);
        this.ei = new ExecutableItemFeature((FeatureParentInterface)this, (FeatureSettingsInterface)FeatureSettingsSCore.executableItem);
        this.ei.setReturnErrorIfExecItemNotExists(true);
        this.sitFeatures = new SitFeatures((FeatureParentInterface)this);
        this.storageFeatures = new StorageFeatures((FeatureParentInterface)this);
    }

    @KeepMethod
    public Item dropItem(Location location, int amount) {
        return this.dropItem(location, amount, null);
    }

    @KeepMethod
    public Item dropItem(Location location, int amount, Optional<Player> creatorOpt, Map<String, Object> settings) {
        ItemStack item = this.buildItem(amount, Optional.empty(), settings);
        return location.getWorld().dropItem(location, item);
    }

    public ItemStack buildItem(int amount, Optional<Player> creator, boolean forceHideMadeWith) {
        return this.buildItem(amount, new InternalData().setOwnerUUID((UUID)creator.map(Entity::getUniqueId).orElse(null)), forceHideMadeWith);
    }

    @KeepMethod
    public ItemStack buildItem(int i, @Nullable InternalData internalData) {
        return this.buildItem(i, internalData, false);
    }

    @KeepMethod
    public ItemStack buildItem(int i, Optional<Player> optional) {
        return this.buildItem(i, optional, false);
    }

    @KeepMethod
    public ItemStack buildItem(int amount, Optional<Player> creator, Map<String, Object> settings) {
        return this.buildItem(amount, creator, settings, false);
    }

    public ItemStack buildItem(int amount, Optional<Player> creator, Map<String, Object> settings, boolean forceHideMadeWith) {
        ItemStack item = null;
        Optional eiOpt = this.ei.getBuildable();
        if (eiOpt.isPresent()) {
            item = ((SObjectBuildable)eiOpt.get()).buildItem(amount, creator, settings);
        } else {
            Optional<Object> usageOpt = Optional.empty();
            if (settings.containsKey("Usage")) {
                int usage = Integer.valueOf((String)settings.get("Usage"));
                usageOpt = Optional.of(usage);
            }
            HashMap<String, String> variables = new HashMap<String, String>();
            if (settings.containsKey("Variables")) {
                Map read = (Map)settings.get("Variables");
                for (String key : read.keySet()) {
                    variables.put(key, (String)read.get(key));
                }
            }
            InternalData internalData = new InternalData().setOwnerUUID((UUID)creator.map(Entity::getUniqueId).orElse(null)).setVariables(variables);
            usageOpt.ifPresent(arg_0 -> ((InternalData)internalData).setUsage(arg_0));
            item = this.buildItem(amount, internalData);
        }
        if (!forceHideMadeWith) {
            this.addMadeWithParticle(item);
        }
        return item;
    }

    @KeepMethod
    public boolean canBeStacked() {
        return false;
    }

    @KeepMethod
    public String getItemName() {
        return this.getDisplayName();
    }

    public Item dropItem(@NotNull Location location, int amount, @Nullable InternalData overrideInternalData) {
        ItemStack item = this.buildItem(amount, overrideInternalData);
        Item drop = location.getWorld().dropItem(location, item);
        return drop;
    }

    public ItemStack buildItem(int amount, @Nullable InternalData overrideInternalData, boolean forceHideMadeWith) {
        ItemStack item = null;
        Optional eiOpt = this.ei.getBuildable();
        if (eiOpt.isPresent()) {
            item = ((SObjectBuildable)eiOpt.get()).buildItem(amount, overrideInternalData);
        } else {
            if (overrideInternalData == null) {
                overrideInternalData = new InternalData();
            }
            FurnitureObject eBObject = new FurnitureObject(item, this, overrideInternalData.clone());
            item = eBObject.getItem();
            item.setAmount(amount);
            eBObject.getInternalData().getVariableRealsList().buildWithCustomValues(overrideInternalData.getVariables(), item, (UUID)overrideInternalData.getOwnerUUIDOptional().orElse(null));
        }
        if (!forceHideMadeWith) {
            this.addMadeWithParticle(item);
        }
        return item;
    }

    public void addMadeWithParticle(ItemStack item) {
        if (MyFurniture.plugin.isLotOfWork()) {
            ItemMeta meta = item.getItemMeta();
            List<String> lore = new ArrayList();
            if (meta.hasLore()) {
                lore = meta.getLore();
            }
            boolean alreadyMadeWith = false;
            for (String str : lore) {
                if (!StringConverter.deconvertColor((String)str).contains("Made with &5MyFurniture")) continue;
                alreadyMadeWith = true;
                break;
            }
            if (!alreadyMadeWith) {
                lore.add(StringConverter.coloredString((String)"&7"));
                lore.add(StringConverter.coloredString((String)"&7&oMade with &5MyFurniture"));
            }
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
    }

    @KeepMethod
    public Optional<FurniturePlaced> place(@NotNull Location location, OverrideMode override, @Nullable Entity placer, @Nullable InternalData overrideInternalData) {
        FurnitureObject nEOB = new FurnitureObject(null, this, null);
        Optional<FurniturePlaced> eBP = nEOB.createFurniturePlaced(location, override, placer, null, overrideInternalData, null);
        if (!eBP.isPresent() || !(placer instanceof Player)) {
            return eBP;
        }
        FurniturePlaceEvent eBPEvent = new FurniturePlaceEvent((Player)placer, eBP.get(), null);
        if (eBPEvent.isCancelled()) {
            eBP.get().remove();
            return Optional.empty();
        }
        return eBP;
    }

    @KeepMethod
    public boolean hasFurniturePerm(Player player, boolean showError) {
        return this.hasPermission(player, showError);
    }

    @KeepMethod
    public boolean checkIfPlayerCanPlaceAt(@NotNull Player player, @NotNull Location location, boolean showErrorToThePLayer) {
        if (!SafePlace.verifSafePlace((UUID)player.getUniqueId(), (Location)location)) {
            return false;
        }
        if (!this.hasFurniturePerm(player, showErrorToThePLayer)) {
            return false;
        }
        if (!GeneralConfig.getInstance().getWhitelistedWorlds().isEmpty() && !GeneralConfig.getInstance().getWhitelistedWorlds().contains(location.getWorld().getName())) {
            if (showErrorToThePLayer) {
                SendMessage.sendMessageNoPlch((Player)player, (String)StringConverter.replaceVariable((String)MessageMain.getInstance().getMessage((Plugin)MyFurniture.plugin, (MessageInterface)Message.NOT_WHITELISTED_WORLD), (String)player.getName(), (String)"", (String)"", (int)0));
            }
            return false;
        }
        PlayerLimit.PlayerLimitResult plr = PlayerLimit.canPlaceMoreBlocks(player, Optional.of(this.getId()));
        if (!plr.canPlaceMoreBlocks) {
            if (showErrorToThePLayer) {
                SendMessage.sendMessageNoPlch((Player)player, (String)StringConverter.replaceVariable((String)MessageMain.getInstance().getMessage((Plugin)MyFurniture.plugin, (MessageInterface)Message.PLAYER_LIMIT), (String)player.getName(), (String)"", (String)(plr.limit + ""), (int)0));
            }
            return false;
        }
        return true;
    }

    @KeepMethod
    public boolean checkIfPlayerCanBreakAt(@NotNull Player player, @NotNull Location location, boolean showErrorToThePLayer) {
        if (!SafeBreak.verifSafeBreak((UUID)player.getUniqueId(), (Location)location)) {
            return false;
        }
        return this.hasFurniturePerm(player, showErrorToThePLayer);
    }

    @KeepMethod
    @Nullable
    public SActivator getActivator(String s) {
        for (SActivator acti : this.activatorsFeature.getActivators().values()) {
            if (!acti.getId().equalsIgnoreCase(this.getId())) continue;
            return acti;
        }
        return null;
    }

    @KeepMethod
    public String getId() {
        return super.getId();
    }

    @KeepMethod
    public ExecutableItemFeature getEi() {
        return this.ei;
    }

    @KeepMethod
    public void addCooldown(Player player, int cooldown, boolean isInTicks) {
        for (SActivator activator : this.activatorsFeature.getActivators().values()) {
            if (!(activator instanceof ActivatorMFFeature)) continue;
            ActivatorMFFeature activatorEB = (ActivatorMFFeature)activator;
            activatorEB.getPlayerCooldown().addCooldown((Entity)player, (SObject)this, cooldown, isInTicks);
        }
    }

    @KeepMethod
    public void addCooldown(Player player, int cooldown, boolean isInTicks, String activatorId) {
        for (SActivator activator : this.activatorsFeature.getActivators().values()) {
            if (!(activator instanceof ActivatorMFFeature) || !activatorId.equalsIgnoreCase(activator.getId())) continue;
            ActivatorMFFeature activatorEB = (ActivatorMFFeature)activator;
            activatorEB.getPlayerCooldown().addCooldown((Entity)player, (SObject)this, cooldown, isInTicks);
            break;
        }
    }

    @KeepMethod
    public ActivatorsFeature getActivators() {
        return this.activatorsFeature;
    }

    public boolean hasActiveTitle() {
        return this.title != null && this.title.getValue().getActiveTitle().getValue() != false;
    }

    public String getDisplayName() {
        return Creations.getCreation(this).getDisplayName();
    }

    @KeepMethod
    public UncoloredStringFeature getItemModel() {
        return this.displayFeatures.getItemModel();
    }

    public VariablesGroupFeature getVariables() {
        Optional eiOpt = this.ei.getValue();
        if (eiOpt.isPresent()) {
            return ((ExecutableItemInterface)eiOpt.get()).getVariables();
        }
        return VariablesGroupFeature.buildNull();
    }

    public ActivatorsFeature getActivatorsFeature() {
        return this.activatorsFeature;
    }

    public BlockTitleFeatures getTitle() {
        return this.title;
    }

    public DoubleFeature getInteractionRange() {
        return this.interactionRange;
    }

    public ListExecutableItemsFeature getOnlyBreakableWithEI() {
        return this.onlyBreakableWithEI;
    }

    public BooleanFeature getDropBlockIfItIsBroken() {
        return this.dropBlockIfItIsBroken;
    }

    public DropTypeFeature getDropType() {
        return this.dropType;
    }

    public BooleanFeature getResetInternalDatasWhenBroken() {
        return this.resetInternalDatasWhenBroken;
    }

    public DisplayFeatures getDisplayFeatures() {
        return this.displayFeatures;
    }

    public ItemKeyWriterReader getItemKeyWriterReader() {
        return this.itemKeyWriterReader;
    }

    public SitFeatures getSitFeatures() {
        return this.sitFeatures;
    }

    public StorageFeatures getStorageFeatures() {
        return this.storageFeatures;
    }

    public void setActivatorsFeature(ActivatorsFeature activatorsFeature) {
        this.activatorsFeature = activatorsFeature;
    }

    public void setTitle(BlockTitleFeatures title) {
        this.title = title;
    }

    public void setInteractionRange(DoubleFeature interactionRange) {
        this.interactionRange = interactionRange;
    }

    public void setOnlyBreakableWithEI(ListExecutableItemsFeature onlyBreakableWithEI) {
        this.onlyBreakableWithEI = onlyBreakableWithEI;
    }

    public void setDropBlockIfItIsBroken(BooleanFeature dropBlockIfItIsBroken) {
        this.dropBlockIfItIsBroken = dropBlockIfItIsBroken;
    }

    public void setDropType(DropTypeFeature dropType) {
        this.dropType = dropType;
    }

    public void setResetInternalDatasWhenBroken(BooleanFeature resetInternalDatasWhenBroken) {
        this.resetInternalDatasWhenBroken = resetInternalDatasWhenBroken;
    }

    public void setDisplayFeatures(DisplayFeatures displayFeatures) {
        this.displayFeatures = displayFeatures;
    }

    public void setItemKeyWriterReader(ItemKeyWriterReader itemKeyWriterReader) {
        this.itemKeyWriterReader = itemKeyWriterReader;
    }

    public void setEi(ExecutableItemFeature ei) {
        this.ei = ei;
    }

    public void setSitFeatures(SitFeatures sitFeatures) {
        this.sitFeatures = sitFeatures;
    }

    public void setStorageFeatures(StorageFeatures storageFeatures) {
        this.storageFeatures = storageFeatures;
    }
}

