/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.myfurniture.furniture;

import com.ssomar.myfurniture.MyFurniture;
import com.ssomar.myfurniture.furniture.Furniture;
import com.ssomar.myfurniture.furniture.FurnitureManager;
import com.ssomar.myfurniture.furniture.creations.CreationAbstract;
import com.ssomar.myfurniture.furniture.creations.Creations;
import com.ssomar.myfurniture.furniture.placedfurniture.FurniturePlaced;
import com.ssomar.myfurniture.furniture.placedfurniture.FurniturePlacedManager;
import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.api.myfurniture.config.FurnitureInterface;
import com.ssomar.score.api.myfurniture.config.FurnitureObjectInterface;
import com.ssomar.score.sobject.InternalData;
import com.ssomar.score.sobject.SObjectWithVariables;
import com.ssomar.score.utils.DynamicMeta;
import com.ssomar.score.utils.emums.VariableUpdateType;
import com.ssomar.score.utils.itemwriter.ItemKeyWriterReader;
import com.ssomar.score.utils.itemwriter.ItemKeyWriterReaderManager;
import com.ssomar.score.utils.numbers.NTools;
import com.ssomar.score.utils.obfuscation.KeepClass;
import com.ssomar.score.utils.obfuscation.KeepMethod;
import com.ssomar.score.utils.place.OverrideMode;
import com.ssomar.score.utils.writer.NameSpaceKeyWriterReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KeepClass
public class FurnitureObject
implements FurnitureObjectInterface {
    private Furniture config;
    private InternalData internalData;
    private ItemStack item;
    private boolean valid;
    private ItemKeyWriterReader itemKeyWriterReader = ItemKeyWriterReaderManager.getInstance().getItemKeyWriterReader();
    private static final boolean DEBUG = false;

    @KeepMethod
    public FurnitureObject(@NotNull ItemStack item) {
        this.item = item;
        Optional<Furniture> myFurnitureOpt = FurnitureManager.getInstance().getFurniture(item);
        this.valid = myFurnitureOpt.isPresent();
        this.internalData = new InternalData();
        if (this.valid) {
            this.config = myFurnitureOpt.get();
            this.loadFurnitureInfos();
        }
    }

    public FurnitureObject(@NotNull ItemStack item, List<String> whiteListedEB) {
        this.item = item;
        this.config = FurnitureManager.getInstance().getFurniture(item, whiteListedEB);
        boolean bl = this.valid = this.config != null;
        if (this.valid) {
            this.loadFurnitureInfos();
        }
    }

    public FurnitureObject(@Nullable ItemStack item, @NotNull Furniture config, @Nullable InternalData internalData) {
        this.valid = true;
        this.config = config;
        this.internalData = internalData;
        if (internalData == null) {
            this.internalData = new InternalData();
        }
        this.item = item;
        if (item == null) {
            ItemMeta meta;
            this.item = new ItemStack(MyFurniture.BASE_MATERIAL);
            if (!SCore.is1v21v4Plus()) {
                this.item = new ItemStack(config.getDisplayFeatures().getMaterial().getValue().orElse(MyFurniture.BASE_MATERIAL));
            }
            if ((meta = this.item.getItemMeta()) != null) {
                if (SCore.is1v21v4Plus()) {
                    meta.setItemModel(NamespacedKey.fromString((String)((String)config.getItemModel().getValue().get())));
                } else {
                    meta.setCustomModelData((Integer)config.getDisplayFeatures().getCustomModelData().getValue().get());
                }
                this.item.setItemMeta(meta);
            }
        } else if (!item.hasItemMeta()) {
            this.item.setItemMeta(new ItemStack(item).getItemMeta());
        }
        this.build();
    }

    public void loadFurnitureInfos() {
        if (this.item != null) {
            if (!this.item.hasItemMeta()) {
                this.item.setItemMeta(new ItemStack(this.item.getType()).getItemMeta());
            }
            DynamicMeta dMeta = new DynamicMeta(this.item.getItemMeta());
            this.internalData.loadFromItem(this.item, dMeta, (SObjectWithVariables)this.getConfig());
        }
    }

    public ItemStack build() {
        if (this.valid) {
            DynamicMeta dMeta = new DynamicMeta(this.item.getItemMeta());
            this.addFurnitureTag(dMeta);
            this.item.setItemMeta(dMeta.getMeta());
        }
        return this.item;
    }

    public void addFurnitureTag(DynamicMeta dMeta) {
        this.itemKeyWriterReader.writeString((Plugin)MyFurniture.plugin, this.item, dMeta, "MF-ID", this.config.getId());
    }

    public Optional<FurniturePlaced> createFurniturePlaced(@NotNull Location location, final OverrideMode overrideEBPEnum, @Nullable Entity placer, @Nullable CreationAbstract creation, @Nullable InternalData overrideInternalData, @Nullable BlockFace blockFace) {
        SsomarDev.testMsg((String)"createFurniturePlaced", (boolean)false);
        final InternalData internalData = this.internalData.clone();
        if (overrideInternalData != null) {
            if (overrideInternalData.getUsage() != -1) {
                internalData.setUsage(overrideInternalData.getUsage());
            }
            if (overrideInternalData.getOwnerUUID() != null) {
                internalData.setOwnerUUID(overrideInternalData.getOwnerUUID());
            }
        }
        if (creation == null) {
            creation = Creations.getCreation(this.config);
        }
        final CreationAbstract finalCreation = creation;
        final Location loc = creation.getTheCorrectedPlacementLocation(location, placer, blockFace);
        final Optional[] result = new Optional[]{Optional.empty()};
        BukkitRunnable runnable = new BukkitRunnable(){

            public void run() {
                SsomarDev.testMsg((String)"createFurniturePlaced 2", (boolean)false);
                Optional<FurniturePlaced> eBP2Opt = FurniturePlacedManager.getInstance().getFurniturePlaced(loc);
                if (eBP2Opt.isPresent()) {
                    switch (overrideEBPEnum) {
                        case REMOVE_EXISTING: {
                            eBP2Opt.get().remove();
                            break;
                        }
                        case KEEP_EXISTING: {
                            return;
                        }
                        case BREAK_EXISTING: {
                            eBP2Opt.get().breakFurniture(null, true, null, FurniturePlaced.BreakMethod.CUSTOM);
                        }
                    }
                }
                finalCreation.place(loc);
                finalCreation.afterPlacingModification(loc);
                Entity mainEntity = finalCreation.getMainEntity();
                PersistentDataContainer persistentDataContainer = mainEntity.getPersistentDataContainer();
                NameSpaceKeyWriterReader.writeString((Plugin)SCore.plugin, (PersistentDataContainer)persistentDataContainer, (String)"MF-ID", (String)FurnitureObject.this.getConfig().getId());
                internalData.saveInEntity(mainEntity);
                SsomarDev.testMsg((String)"createFurniturePlaced 5", (boolean)false);
                FurniturePlaced eBP = new FurniturePlaced(mainEntity, loc, finalCreation, FurnitureObject.this.config.getId(), internalData);
                FurniturePlacedManager.getInstance().addFurniturePlaced(eBP);
                Location holoLoc = FurnitureObject.this.config.getTitle().spawn(eBP.getLocation(), eBP.getPlaceholders());
                if (holoLoc != null) {
                    eBP.setHoloLocation(holoLoc);
                }
                SsomarDev.testMsg((String)"createFurniturePlaced 6", (boolean)false);
                result[0] = Optional.of(eBP);
                SsomarDev.testMsg((String)"createFurniturePlaced 7 ", (boolean)false);
            }
        };
        SCore.schedulerHook.runLocationTaskAsap((Runnable)runnable, loc);
        return result[0];
    }

    public void overrideConfig(Furniture executableBlock) {
        this.config = executableBlock;
    }

    @KeepMethod
    public boolean isValid() {
        return this.valid;
    }

    @KeepMethod
    public InternalData getInternalData() {
        return this.internalData;
    }

    @KeepMethod
    public FurnitureInterface getFurnitureConfig() {
        return this.config;
    }

    public HashMap<String, String> getVariablesValues() {
        return (HashMap)this.internalData.getVariables();
    }

    public String updateVariable(String variableName, String value, VariableUpdateType type) {
        variableName = variableName.toUpperCase();
        Map variables = this.internalData.getVariables();
        if (type.equals((Object)VariableUpdateType.MODIFICATION)) {
            if (NTools.isNumber((String)value) && variables.containsKey(variableName) && NTools.isNumber((String)((String)variables.get(variableName)))) {
                double newValue = Double.parseDouble(value);
                double oldValue = Double.parseDouble((String)variables.get(variableName));
                double addition = newValue + oldValue;
                variables.put(variableName, addition + "");
            } else {
                variables.put(variableName, (String)variables.get(variableName) + "" + value);
            }
        } else {
            variables.put(variableName, value);
        }
        UUID uuid = this.internalData.getOwnerUUID();
        this.internalData.getVariableRealsList().buildWithCustomValues(variables, this.getItem(), uuid);
        return (String)variables.get(variableName);
    }

    public int getUsage() {
        return this.internalData.getUsage();
    }

    public Furniture getConfig() {
        return this.config;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public ItemKeyWriterReader getItemKeyWriterReader() {
        return this.itemKeyWriterReader;
    }

    public void setItem(ItemStack item) {
        this.item = item;
    }
}

