/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.myfurniture.furniture.placedfurniture;

import com.ssomar.myfurniture.furniture.placedfurniture.FurniturePlaced;
import java.util.Comparator;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public enum SortFurniturePlaced {
    EB_ID,
    LOCATION,
    OWNER_NAME;


    public Comparator<FurniturePlaced> getComparator() {
        switch (this.ordinal()) {
            case 0: {
                return Comparator.comparing(FurniturePlaced::getMF_ID);
            }
            case 1: {
                Comparator<FurniturePlaced> comparator = new Comparator<FurniturePlaced>(){

                    @Override
                    public int compare(FurniturePlaced o1, FurniturePlaced o2) {
                        Location l1 = o1.getLocation();
                        Location l2 = o2.getLocation();
                        if (l1.getWorld() != l2.getWorld()) {
                            return l1.getWorld().getName().compareTo(l2.getWorld().getName());
                        }
                        if (l1.getBlockX() != l2.getBlockX()) {
                            return Integer.compare(l1.getBlockX(), l2.getBlockX());
                        }
                        if (l1.getBlockY() != l2.getBlockY()) {
                            return Integer.compare(l1.getBlockY(), l2.getBlockY());
                        }
                        if (l1.getBlockZ() != l2.getBlockZ()) {
                            return Integer.compare(l1.getBlockZ(), l2.getBlockZ());
                        }
                        return o1.getLocation().toString().compareTo(o2.getLocation().toString());
                    }
                };
                return comparator;
            }
            case 2: {
                Comparator<FurniturePlaced> comparator2 = new Comparator<FurniturePlaced>(){

                    @Override
                    public int compare(FurniturePlaced o1, FurniturePlaced o2) {
                        Optional p1 = o1.getInternalData().getOwnerOptional();
                        Optional p2 = o2.getInternalData().getOwnerOptional();
                        if (p1.isPresent() && p2.isPresent()) {
                            return ((Player)p1.get()).getName().compareTo(((Player)p2.get()).getName());
                        }
                        if (p1.isPresent()) {
                            return -1;
                        }
                        if (p2.isPresent()) {
                            return 1;
                        }
                        return 0;
                    }
                };
                return comparator2;
            }
        }
        return Comparator.comparing(FurniturePlaced::getMF_ID);
    }
}

