/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.myfurniture.texturesloader;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.ssomar.myfurniture.MyFurniture;
import com.ssomar.myfurniture.features.display.boundingboxzones.boundingboxzone.BoundingBoxZoneFeature;
import com.ssomar.myfurniture.features.display.boundingboxzones.group.BoundingBoxZoneGroupFeature;
import com.ssomar.myfurniture.texturesloader.TexturesPackLoader;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.logging.Utils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;

public class ModelFile {
    private File file;
    private JsonNode jsonNode;

    public ModelFile(File file) {
        this.file = file;
        try {
            this.jsonNode = TexturesPackLoader.getMapper().readTree(file);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while reading the model file: " + file.getPath());
        }
    }

    public String getModelFilePath() {
        return this.file.getPath();
    }

    public String getModelPathInConfig() {
        return this.getModelFilePath().replace(TexturesPackLoader.assetsFolder, "").replace(".json", "").replace(File.separator + "models" + File.separator, ":");
    }

    public String getModelPathInConfigWithoutId() {
        String modelPathInConfig = this.getModelPathInConfig();
        return modelPathInConfig.substring(0, modelPathInConfig.lastIndexOf(File.separator) + 1);
    }

    public String getModelId() {
        String modelPathInConfig = this.getModelPathInConfig();
        if (modelPathInConfig.startsWith(File.separator)) {
            modelPathInConfig = modelPathInConfig.substring(1);
        }
        if (!modelPathInConfig.contains(File.separator)) {
            return modelPathInConfig.split(":")[1];
        }
        return modelPathInConfig.substring(modelPathInConfig.lastIndexOf(File.separator) + 1);
    }

    public String getModelParentPath() {
        String parent = this.getModelPathInConfig().replace(":", File.separator).substring(0, this.getModelPathInConfig().lastIndexOf(File.separator) + 1);
        if (parent.startsWith(File.separator)) {
            parent = parent.substring(1);
        }
        return parent;
    }

    public File getBoundingBoxFile() {
        JsonNode parentNode = this.jsonNode.get("parent");
        if (parentNode != null) {
            String parentModel = parentNode.asText();
            if (parentModel.contains("./")) {
                parentModel = this.getModelPathInConfigWithoutId() + parentModel.replace("./", "");
                if ((parentModel = parentModel.replace(File.separator, "/")).startsWith("/")) {
                    parentModel = parentModel.substring(1);
                }
                ((ObjectNode)this.jsonNode).put("parent", parentModel);
                try (FileWriter writer = new FileWriter(this.file);){
                    TexturesPackLoader.getMapper().writeValue((Writer)writer, (Object)this.jsonNode);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else if (parentModel.startsWith(File.separator)) {
                parentModel = parentModel.substring(1);
                ((ObjectNode)this.jsonNode).put("parent", parentModel);
                try (FileWriter writer = new FileWriter(this.file);){
                    TexturesPackLoader.getMapper().writeValue((Writer)writer, (Object)this.jsonNode);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else if (!parentModel.contains(":")) {
                parentModel = this.getModelPathInConfigWithoutId() + parentModel.replace("./", "");
                if ((parentModel = parentModel.replace(File.separator, "/")).startsWith("/")) {
                    parentModel = parentModel.substring(1);
                }
                ((ObjectNode)this.jsonNode).put("parent", parentModel);
                try (FileWriter writer = new FileWriter(this.file);){
                    TexturesPackLoader.getMapper().writeValue((Writer)writer, (Object)this.jsonNode);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return new File(TexturesPackLoader.assetsFolder + File.separator + parentModel.replace(":", File.separator + "models" + File.separator) + ".json");
        }
        return this.file;
    }

    public void fillBoundingBoxZoneGroupFeature(BoundingBoxZoneGroupFeature group) {
        block5: {
            try {
                JsonNode boundingBoxObject = TexturesPackLoader.getMapper().readTree(this.getBoundingBoxFile());
                ArrayNode elements = (ArrayNode)boundingBoxObject.get("elements");
                if (elements == null) {
                    Utils.sendConsoleMsg((SPlugin)MyFurniture.plugin, (String)("&cNo bounding box found for the model: " + this.getModelId()));
                    return;
                }
                Iterator elementsIterator = elements.iterator();
                int i = 0;
                while (elementsIterator.hasNext()) {
                    JsonNode element = (JsonNode)elementsIterator.next();
                    ArrayNode from = (ArrayNode)element.get("from");
                    ArrayNode to = (ArrayNode)element.get("to");
                    BoundingBoxZoneFeature boundingBoxZoneFeature = new BoundingBoxZoneFeature(group, i + "");
                    Object[] fromArray = new Double[3];
                    Object[] toArray = new Double[3];
                    for (int j = 0; j < 3; ++j) {
                        double fromNumber = from.get(j).asDouble();
                        fromArray[j] = fromNumber;
                        double toNumber = to.get(j).asDouble();
                        toArray[j] = toNumber;
                    }
                    boundingBoxZoneFeature.getFrom().setValue(fromArray);
                    boundingBoxZoneFeature.getTo().setValue(toArray);
                    group.getBoundingBoxZones().put(i + "", boundingBoxZoneFeature);
                    ++i;
                }
            }
            catch (IOException e) {
                String boundingBoxPath = this.getBoundingBoxFile().getPath();
                if (boundingBoxPath.contains("generated.json")) break block5;
                Utils.sendConsoleMsg((SPlugin)MyFurniture.plugin, (String)("&cError while reading the bounding box file: " + this.getBoundingBoxFile().getPath() + " for the model " + this.getModelId()));
            }
        }
    }

    public File getFile() {
        return this.file;
    }

    public JsonNode getJsonNode() {
        return this.jsonNode;
    }
}

