/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.myfurniture.furniture;

import com.ssomar.myfurniture.MyFurniture;
import com.ssomar.myfurniture.configs.api.PlaceholderAPI;
import com.ssomar.myfurniture.furniture.ConfigConverter;
import com.ssomar.myfurniture.furniture.Furniture;
import com.ssomar.myfurniture.furniture.FurnitureManager;
import com.ssomar.score.events.loop.LoopManager;
import com.ssomar.score.sobject.SObjectWithFileLoader;
import com.ssomar.score.sobject.SObjectWithFileManager;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.logging.Utils;
import com.ssomar.score.utils.obfuscation.KeepMethod;
import com.ssomar.score.utils.strings.StringConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public class FurnitureLoader
extends SObjectWithFileLoader<Furniture> {
    private static FurnitureLoader instance;
    private static final String EXAMPLE = "Example";

    public FurnitureLoader() {
        super((SPlugin)MyFurniture.plugin, "/com/ssomar/myfurniture/configs/furniture/", (SObjectWithFileManager)FurnitureManager.getInstance(), 300);
    }

    @KeepMethod
    public void load() {
        LoopManager.getInstance().resetLoopActivators((SPlugin)MyFurniture.plugin);
        FurnitureManager.getInstance().setDefaultObjects(new ArrayList());
        this.loadDefaultEncodedPremiumObjects(this.getPremiumPackObjectsName());
        FurnitureManager.getInstance().setLoadedObjects(new ArrayList());
        this.resetCpt();
        File itemsDirectory = new File(MyFurniture.getPluginSt().getDataFolder() + "/furniture");
        if (itemsDirectory.exists()) {
            this.loadObjectsInFolder(itemsDirectory, !PlaceholderAPI.isLotOfWork());
            Utils.sendConsoleMsg((String)("&5MyFurniture &7Amount of Furniture configurations loaded: &e" + this.getCpt()));
        } else {
            this.createDefaultObjectsFile(!PlaceholderAPI.isLotOfWork());
            this.load();
        }
    }

    public Map<String, List<String>> getPremiumPackObjectsName() {
        HashMap<String, List<String>> defaultItems = new HashMap<String, List<String>>();
        return defaultItems;
    }

    @KeepMethod
    public void configVersionsConverter(File file) {
        ConfigConverter.updateTo(file);
    }

    @KeepMethod
    public Optional<Furniture> getObject(FileConfiguration itemConfig, String id, boolean showError, boolean isPremiumLoading, String path) {
        ArrayList<String> errors = new ArrayList<String>();
        Furniture item = new Furniture(id, path);
        errors.addAll(item.load(MyFurniture.plugin, (ConfigurationSection)itemConfig, isPremiumLoading));
        if (showError) {
            for (String s : errors) {
                Utils.sendConsoleMsg((String)("&5MyFurniture " + StringConverter.coloredString((String)s)));
            }
        }
        return Optional.ofNullable(item);
    }

    public static FurnitureLoader getInstance() {
        if (instance == null) {
            instance = new FurnitureLoader();
        }
        return instance;
    }
}

